/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.trusteddevice;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseCookie;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureCredentialsExpiredEvent;
import org.springframework.security.authentication.event.AuthenticationFailureDisabledEvent;
import org.springframework.security.authentication.event.AuthenticationFailureExpiredEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/authorization/trusteddevice/TrustedDeviceAuthenticationHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "trustedDeviceService", "Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;", "cookieMaxAgeInDays", "", "<init>", "(Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;J)V", "getCookieMaxAgeInDays", "()J", "createDeviceCookieTokenFromAuthentication", "", "successfulAuthentication", "Lorg/springframework/security/core/Authentication;", "addCookie", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "onAuthenticationSuccess", "request", "Ljakarta/servlet/http/HttpServletRequest;", "handleAuthenticationFailure", "event", "Lorg/springframework/security/authentication/event/AbstractAuthenticationFailureEvent;", "just-authorization-server"})
public class TrustedDeviceAuthenticationHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final TrustedDeviceService trustedDeviceService;
    private final long cookieMaxAgeInDays;

    public TrustedDeviceAuthenticationHandler(@NotNull TrustedDeviceService trustedDeviceService, @Value(value="${just.security.trusteddevicecookie.maxAgeInDays:30}") long cookieMaxAgeInDays) {
        Intrinsics.checkNotNullParameter((Object)trustedDeviceService, (String)"trustedDeviceService");
        this.trustedDeviceService = trustedDeviceService;
        this.cookieMaxAgeInDays = cookieMaxAgeInDays;
    }

    public long getCookieMaxAgeInDays() {
        return this.cookieMaxAgeInDays;
    }

    private String createDeviceCookieTokenFromAuthentication(Authentication successfulAuthentication) {
        Object object = successfulAuthentication.getPrincipal();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.oauth2.JustUser");
        JustUser justUser = (JustUser)object;
        ProfileId profileId = justUser.getProfileId();
        Duration duration = Duration.ofDays(this.getCookieMaxAgeInDays());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        return this.trustedDeviceService.issueTrustedDeviceToken(profileId, duration);
    }

    public void addCookie(@NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            String string = this.createDeviceCookieTokenFromAuthentication(authentication);
            if (string == null) break block0;
            String token = string;
            boolean bl = false;
            ResponseCookie responseCookie = ResponseCookie.from((String)"trusted-device", (String)token).maxAge(Duration.ofDays(this.getCookieMaxAgeInDays())).secure(true).httpOnly(true).path("/").build();
            Intrinsics.checkNotNullExpressionValue((Object)responseCookie, (String)"build(...)");
            ResponseCookie cookie = responseCookie;
            response.addHeader("Set-Cookie", cookie.toString());
        }
    }

    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        if (authentication.getPrincipal() instanceof UsernamePasswordAuthenticationToken) {
            Object object = authentication.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.security.authentication.UsernamePasswordAuthenticationToken");
            this.addCookie(response, (Authentication)((UsernamePasswordAuthenticationToken)object));
        } else if (authentication.getPrincipal() instanceof TOTPAuthentication) {
            Object object = authentication.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.totp.TOTPAuthentication");
            TOTPAuthentication totpAuth = (TOTPAuthentication)object;
            if (totpAuth.getAuthenticated()) {
                this.addCookie(response, totpAuth.getInitial());
            }
        }
    }

    @EventListener(classes={AuthenticationFailureBadCredentialsEvent.class, AuthenticationFailureLockedEvent.class, AuthenticationFailureExpiredEvent.class, AuthenticationFailureDisabledEvent.class, AuthenticationFailureCredentialsExpiredEvent.class, TOTPAuthenticationException.class})
    public void handleAuthenticationFailure(@NotNull AbstractAuthenticationFailureEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getAuthentication().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.trustedDeviceService.countFailedAuthentication(string);
    }
}

