/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.trusteddevice;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.trusteddevice.AccountFailedLogin;
import de.justsoftware.authorization.trusteddevice.AccountLock;
import de.justsoftware.authorization.trusteddevice.AccountLockRepository;
import de.justsoftware.authorization.trusteddevice.AccountLockService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/authorization/trusteddevice/AccountLockService;", "", "accountLockRepository", "Lde/justsoftware/authorization/trusteddevice/AccountLockRepository;", "maxFailedAttempts", "", "lockoutMinutes", "", "<init>", "(Lde/justsoftware/authorization/trusteddevice/AccountLockRepository;IJ)V", "getMaxFailedAttempts", "()I", "getLockoutMinutes", "()J", "lockAccountIfNecessary", "", "failedLogin", "Lde/justsoftware/authorization/trusteddevice/AccountFailedLogin;", "isAccountLocked", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "Companion", "just-authorization-server"})
public class AccountLockService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AccountLockRepository accountLockRepository;
    private final int maxFailedAttempts;
    private final long lockoutMinutes;
    @NotNull
    private static final Logger LOG;

    public AccountLockService(@NotNull AccountLockRepository accountLockRepository, @Value(value="${just.security.failedLogin.maxAttempts:5}") int maxFailedAttempts, @Value(value="${just.security.failedLogin.lockoutMinutes:60}") long lockoutMinutes) {
        Intrinsics.checkNotNullParameter((Object)accountLockRepository, (String)"accountLockRepository");
        this.accountLockRepository = accountLockRepository;
        this.maxFailedAttempts = maxFailedAttempts;
        this.lockoutMinutes = lockoutMinutes;
    }

    public int getMaxFailedAttempts() {
        return this.maxFailedAttempts;
    }

    public long getLockoutMinutes() {
        return this.lockoutMinutes;
    }

    public void lockAccountIfNecessary(@NotNull AccountFailedLogin failedLogin) {
        Intrinsics.checkNotNullParameter((Object)failedLogin, (String)"failedLogin");
        if (failedLogin.getFailCount() > this.getMaxFailedAttempts()) {
            Instant lockedUntil = Instant.now().plus(this.getLockoutMinutes(), ChronoUnit.MINUTES);
            ProfileId profileId = failedLogin.getProfileId();
            Intrinsics.checkNotNull((Object)lockedUntil);
            this.accountLockRepository.insertOrUpdateAccountLock(profileId, lockedUntil);
            LOG.warn("{}'s account is locked for {} minutes.", (Object)failedLogin.getProfileId(), (Object)this.getLockoutMinutes());
        }
    }

    public boolean isAccountLocked(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        AccountLock lock = this.accountLockRepository.findAccountLockByProfileId(profileId);
        if (lock == null) {
            return false;
        }
        return Instant.now().isBefore(lock.getLockedUntil());
    }

    static {
        Logger logger = LoggerFactory.getLogger(AccountLockService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

