/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.stats.UserStatsService;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "systemDomainPrefix", "", "userStatsService", "Lde/justsoftware/authorization/stats/UserStatsService;", "<init>", "(Ljava/lang/String;Lde/justsoftware/authorization/stats/UserStatsService;)V", "requestCache", "Lorg/springframework/security/web/savedrequest/RequestCache;", "onAuthenticationSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "Lorg/springframework/security/core/Authentication;", "countMobileLogin", "isMobileLogin", "", "just-authorization-server"})
public class TOTPAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private final UserStatsService userStatsService;
    @NotNull
    private final RequestCache requestCache;

    public TOTPAuthenticationSuccessHandler(@Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @NotNull UserStatsService userStatsService) {
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)userStatsService, (String)"userStatsService");
        this.systemDomainPrefix = systemDomainPrefix;
        this.userStatsService = userStatsService;
        this.requestCache = (RequestCache)new HttpSessionRequestCache();
    }

    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        if (authentication instanceof TOTPAuthentication && !((TOTPAuthentication)authentication).getAuthenticated()) {
            SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler("/totp/login");
            successHandler.setAlwaysUseDefaultTargetUrl(true);
            successHandler.onAuthenticationSuccess(request, response, authentication);
        } else {
            this.countMobileLogin(authentication, request, response);
            SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
            handler.setRequestCache(this.requestCache);
            handler.setDefaultTargetUrl(this.systemDomainPrefix);
            handler.onAuthenticationSuccess(request, response, authentication);
        }
    }

    private void countMobileLogin(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        if (this.isMobileLogin(request, response) && authentication.getPrincipal() instanceof JustUser) {
            Object object = authentication.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.oauth2.JustUser");
            JustUser user = (JustUser)object;
            this.userStatsService.updateLastLoginMobile(user.getProfileId());
        }
    }

    private boolean isMobileLogin(HttpServletRequest request, HttpServletResponse response) {
        String[] savedRequest;
        String[] stringArray = savedRequest = this.requestCache.getRequest(request, response);
        String clientId = savedRequest != null && (stringArray = (String[])stringArray.getParameterMap().get("client_id")) != null ? stringArray[0] : null;
        return Intrinsics.areEqual((Object)"just-login-mobile", clientId);
    }
}

