/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.stats;

import de.justsoftware.authorization.kafka.KafkaConsumerConfiguration;
import de.justsoftware.authorization.stats.UserActivity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@Configuration
@EnableKafka
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0012J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/authorization/stats/UserStatsKafkaConfiguration;", "", "kafkaConsumerConfiguration", "Lde/justsoftware/authorization/kafka/KafkaConsumerConfiguration;", "<init>", "(Lde/justsoftware/authorization/kafka/KafkaConsumerConfiguration;)V", "createConsumerFactory", "Lorg/springframework/kafka/core/ConsumerFactory;", "", "Lde/justsoftware/authorization/stats/UserActivity;", "userStatsKafkaListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "just-authorization-server"})
public class UserStatsKafkaConfiguration {
    @NotNull
    private final KafkaConsumerConfiguration kafkaConsumerConfiguration;

    public UserStatsKafkaConfiguration(@NotNull KafkaConsumerConfiguration kafkaConsumerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerConfiguration, (String)"kafkaConsumerConfiguration");
        this.kafkaConsumerConfiguration = kafkaConsumerConfiguration;
    }

    private ConsumerFactory<String, UserActivity> createConsumerFactory() {
        Map props = this.kafkaConsumerConfiguration.defaultConsumerConfig();
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        JsonDeserializer jsonDeserializer = new JsonDeserializer(UserActivity.class);
        jsonDeserializer.setUseTypeHeaders(false);
        return (ConsumerFactory)new DefaultKafkaConsumerFactory(props, (Deserializer)new ErrorHandlingDeserializer((Deserializer)new StringDeserializer()), (Deserializer)new ErrorHandlingDeserializer((Deserializer)jsonDeserializer));
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, UserActivity> userStatsKafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.createConsumerFactory());
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)new FixedBackOff(0L, 0L)));
        return factory;
    }
}

