/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller.internal;

import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.oauth2.client.ApiTokenService;
import de.justsoftware.authorization.token.ApiToken;
import de.justsoftware.authorization.token.Scope;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/scim"}, produces={"application/json"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/authorization/controller/internal/InternalSCIMTokenController;", "", "apiTokenService", "Lde/justsoftware/authorization/oauth2/client/ApiTokenService;", "<init>", "(Lde/justsoftware/authorization/oauth2/client/ApiTokenService;)V", "getApiTokenService", "()Lde/justsoftware/authorization/oauth2/client/ApiTokenService;", "generateScimToken", "Lde/justsoftware/authorization/token/ApiToken;", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "getCurrentToken", "deleteScimTokens", "", "just-authorization-server"})
public class InternalSCIMTokenController {
    @NotNull
    private final ApiTokenService apiTokenService;

    public InternalSCIMTokenController(@NotNull ApiTokenService apiTokenService) {
        Intrinsics.checkNotNullParameter((Object)apiTokenService, (String)"apiTokenService");
        this.apiTokenService = apiTokenService;
    }

    @NotNull
    public ApiTokenService getApiTokenService() {
        return this.apiTokenService;
    }

    @PostMapping(value={"/token"})
    @NotNull
    public ApiToken generateScimToken(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getApiTokenService().generateApiTokenForScope(authContext, SetsKt.setOf((Object)Scope.SCIM));
    }

    @GetMapping(value={"/token"})
    @Nullable
    public ApiToken getCurrentToken(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.getApiTokenService().getCurrentApiToken(authContext, SetsKt.setOf((Object)Scope.SCIM));
    }

    @DeleteMapping(value={"/token"})
    public void deleteScimTokens(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.getApiTokenService().deleteApiTokensForScope(authContext, SetsKt.setOf((Object)Scope.SCIM));
    }
}

