/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.token.JWTService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jwt"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/authorization/controller/JWTController;", "", "jwtService", "Lde/justsoftware/authorization/token/JWTService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lde/justsoftware/authorization/token/JWTService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getJWT", "", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "just-authorization-server"})
public class JWTController {
    @NotNull
    private final JWTService jwtService;
    @NotNull
    private final ObjectMapper objectMapper;

    public JWTController(@NotNull JWTService jwtService, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.jwtService = jwtService;
        this.objectMapper = objectMapper;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public String getJWT(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        String justId = this.jwtService.createJwt(authContext);
        String string = this.objectMapper.writeValueAsString((Object)justId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

