/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import de.justsoftware.authorization.config.ZookeeperConfigService;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.stereotype.Service;

@ConditionalOnZookeeperEnabled
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/authorization/config/ZookeeperConfigServiceImpl;", "Lde/justsoftware/authorization/config/ZookeeperConfigService;", "zookeeperClient", "Lorg/apache/curator/framework/CuratorFramework;", "<init>", "(Lorg/apache/curator/framework/CuratorFramework;)V", "getZookeeperClient", "()Lorg/apache/curator/framework/CuratorFramework;", "getOrGenerate", "", "path", "generator", "Lkotlin/Function0;", "store", "", "data", "", "just-authorization-server"})
public class ZookeeperConfigServiceImpl
implements ZookeeperConfigService {
    @NotNull
    private final CuratorFramework zookeeperClient;

    public ZookeeperConfigServiceImpl(@NotNull CuratorFramework zookeeperClient) {
        Intrinsics.checkNotNullParameter((Object)zookeeperClient, (String)"zookeeperClient");
        this.zookeeperClient = zookeeperClient;
    }

    @NotNull
    public CuratorFramework getZookeeperClient() {
        return this.zookeeperClient;
    }

    @NotNull
    public String getOrGenerate(@NotNull String path, @NotNull Function0<String> generator) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        ExistsBuilder existsBuilder = this.getZookeeperClient().checkExists();
        Stat result = (Stat)existsBuilder.forPath(path);
        if (result == null) {
            Object object = this.getZookeeperClient().getData().forPath(path);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forPath(...)");
            byte[] byArray = (byte[])object;
            Charset charset = Charsets.UTF_8;
            return new String(byArray, charset);
        }
        String data = (String)generator.invoke();
        this.store(path, data);
        return data;
    }

    public void store(@NotNull String path, @Nullable String data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = data;
        if (string != null) {
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        this.store(path, byArray);
    }

    private void store(String path, byte[] data) {
        ExistsBuilder existsBuilder = this.getZookeeperClient().checkExists();
        Stat result = (Stat)existsBuilder.forPath(path);
        if (result == null) {
            ACLBackgroundPathAndBytesable creator = (ACLBackgroundPathAndBytesable)this.getZookeeperClient().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
            v0 = creator.forPath(path, data);
        } else {
            SetDataBuilder updater = this.getZookeeperClient().setData();
            v0 = updater.forPath(path, data);
        }
    }
}

