/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.toolbox.result;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.admin.mybatis.toolbox.result.CollectorResultHandler;
import de.justsoftware.admin.mybatis.toolbox.result.ResultHandlerBuilder;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class MapResultHandlerBuilder<ID, K, V, DB_RESULT> {
    final Function<? super DB_RESULT, K> _keyFunction;
    final Function<? super DB_RESULT, V> _valueFunction;
    final ResultHandlerBuilder<ID> _resultHandlerBuilder;

    MapResultHandlerBuilder(ResultHandlerBuilder<ID> resultHandlerBuilder, Function<? super DB_RESULT, K> keyFunction, Function<? super DB_RESULT, V> valueFunction) {
        this._resultHandlerBuilder = resultHandlerBuilder;
        this._keyFunction = keyFunction;
        this._valueFunction = valueFunction;
    }

    @Nonnull
    private <R> CollectorResultHandler<ID, DB_RESULT, ?, R> collect(Collector<DB_RESULT, ?, R> collector) {
        return new CollectorResultHandler(this._resultHandlerBuilder, collector);
    }

    @Nonnull
    public CollectorResultHandler<ID, DB_RESULT, ?, ImmutableMap<K, V>> asMap() {
        return this.collect(ImmutableMap.toImmutableMap((Function)this._keyFunction, (Function)this._valueFunction));
    }

    @Nonnull
    public CollectorResultHandler<ID, DB_RESULT, ?, ImmutableBiMap<K, V>> asBiMap() {
        return this.collect(ImmutableBiMap.toImmutableBiMap((Function)this._keyFunction, (Function)this._valueFunction));
    }

    @Nonnull
    public CollectorResultHandler<ID, DB_RESULT, ?, ImmutableSetMultimap<K, V>> asSetMultimap() {
        return this.collect(ImmutableSetMultimap.toImmutableSetMultimap((Function)this._keyFunction, (Function)this._valueFunction));
    }

    @Nonnull
    public CollectorResultHandler<ID, DB_RESULT, ?, ImmutableListMultimap<K, V>> asListMultimap() {
        return this.collect(ImmutableListMultimap.toImmutableListMultimap((Function)this._keyFunction, (Function)this._valueFunction));
    }
}

