/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/security/WebSecurityConfiguration;", "", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "graphiQlPath", "", "internalBasePath", "<init>", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;Ljava/lang/String;Ljava/lang/String;)V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "admin-service"})
public class WebSecurityConfiguration {
    @NotNull
    private final JwtVerifier jwtVerifier;
    @NotNull
    private final String graphiQlPath;
    @NotNull
    private final String internalBasePath;

    @Autowired
    public WebSecurityConfiguration(@NotNull JwtVerifier jwtVerifier, @Value(value="${dgs.graphql.graphiql.path}") @NotNull String graphiQlPath, @Value(value="${internal.base-path}") @NotNull String internalBasePath) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)graphiQlPath, (String)"graphiQlPath");
        Intrinsics.checkNotNullParameter((Object)internalBasePath, (String)"internalBasePath");
        this.jwtVerifier = jwtVerifier;
        this.graphiQlPath = graphiQlPath;
        this.internalBasePath = internalBasePath;
    }

    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Object object = http.sessionManagement(WebSecurityConfiguration::securityFilterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::securityFilterChain$lambda$1).anonymous(Customizer.withDefaults()).headers(WebSecurityConfiguration::securityFilterChain$lambda$2).authorizeHttpRequests(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$3(this, arg_0)).addFilterAfter((Filter)new JwtAuthenticationProcessingFilter(this.jwtVerifier), AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void securityFilterChain$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void securityFilterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void securityFilterChain$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void securityFilterChain$lambda$3(WebSecurityConfiguration this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = new String[]{this$0.graphiQlPath};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{this$0.internalBasePath + "/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }
}

