/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.deserializier;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.admin.kafka.model.KafkaProfileMessage;
import de.justsoftware.admin.kafka.model.ProfileKafkaJsonMap;
import de.justsoftware.admin.util.ProfileIdDeserializer;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.support.serializer.DeserializationException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/kafka/deserializier/KafkaProfileMessageDeserializer;", "Lorg/apache/kafka/common/serialization/Deserializer;", "Lde/justsoftware/admin/kafka/model/KafkaProfileMessage;", "<init>", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "topic", "", "data", "", "admin-service"})
@SourceDebugExtension(value={"SMAP\nKafkaProfileMessageDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaProfileMessageDeserializer.kt\nde/justsoftware/admin/kafka/deserializier/KafkaProfileMessageDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class KafkaProfileMessageDeserializer
implements Deserializer<KafkaProfileMessage> {
    @NotNull
    private final ObjectMapper jsonMapper;

    public KafkaProfileMessageDeserializer() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        this.jsonMapper = objectMapper;
        this.jsonMapper.registerModule((Module)ProfileIdDeserializer.INSTANCE);
    }

    @NotNull
    public KafkaProfileMessage deserialize(@Nullable String topic, @Nullable byte[] data) {
        KafkaProfileMessage kafkaProfileMessage;
        byte[] byArray = data;
        if (data == null) {
            boolean $i$a$-requireNotNull-KafkaProfileMessageDeserializer$deserialize$22 = false;
            String $i$a$-requireNotNull-KafkaProfileMessageDeserializer$deserialize$22 = "Can not deserialize null data";
            throw new IllegalArgumentException($i$a$-requireNotNull-KafkaProfileMessageDeserializer$deserialize$22.toString());
        }
        try {
            KafkaProfileMessage kafkaProfileMessage2;
            ProfileKafkaJsonMap profileKafkaJsonMap = (ProfileKafkaJsonMap)this.jsonMapper.readValue(data, ProfileKafkaJsonMap.class);
            boolean bl = profileKafkaJsonMap.getDeleted();
            if (bl) {
                kafkaProfileMessage2 = (KafkaProfileMessage)profileKafkaJsonMap.toDeleteProfileKafkaDto();
            } else if (!bl) {
                kafkaProfileMessage2 = (KafkaProfileMessage)profileKafkaJsonMap.toProfileKafkaDto();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            kafkaProfileMessage = kafkaProfileMessage2;
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to deserialize data to dto ", data, false, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeserializationException("Failed to deserialize data to dto ", data, false, (Throwable)e);
        }
        return kafkaProfileMessage;
    }
}

