/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql;

import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NoTenantIdInSecurityContextException;
import de.justsoftware.admin.authorization.exceptions.NoUserInSecurityContextException;
import de.justsoftware.admin.connector.permission.PermissionConnector;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/graphql/ContextBuilder;", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "permissionConnector", "Lde/justsoftware/admin/connector/permission/PermissionConnector;", "<init>", "(Lde/justsoftware/admin/connector/permission/PermissionConnector;)V", "build", "getTenantId", "Lde/justsoftware/admin/id/TenantId;", "authentication", "Lorg/springframework/security/core/Authentication;", "admin-service"})
public class ContextBuilder
implements DgsCustomContextBuilder<AuthorizationContext> {
    @NotNull
    private final PermissionConnector permissionConnector;

    public ContextBuilder(@NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.permissionConnector = permissionConnector;
    }

    @NotNull
    public AuthorizationContext build() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new NoUserInSecurityContextException("Cannot get user for unauthenticated access");
        }
        Authentication authentication2 = authentication;
        ProfileId profileId = ProfileId.Companion.fromString(authentication2.getPrincipal().toString());
        TenantId tenantId = this.getTenantId(authentication2);
        AuthorizationContext authorizationContext = new AuthorizationContext(tenantId, profileId, this.permissionConnector);
        if (tenantId == null && !authorizationContext.isSuperAdmin()) {
            throw new NoTenantIdInSecurityContextException("User has no tenantId in security context and is not superadmin");
        }
        return authorizationContext;
    }

    private TenantId getTenantId(Authentication authentication) {
        Intrinsics.checkNotNull((Object)authentication, (String)"null cannot be cast to non-null type de.justsoftware.jwtfilter.JwtAuthenticationToken");
        JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
        Object tenantId = jwt.getCustomJwtClaims().get((Object)"tenantId");
        if (tenantId != null) {
            return TenantId.Companion.fromString(tenantId.toString());
        }
        return null;
    }
}

