/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings.persistence;

import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.mybatis.mapper.AppPermissionMapper;
import de.justsoftware.admin.mybatis.toolbox.DAOSupport;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.ResultHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u0007\u001a\u00020\b2!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J'\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0097\u0001J\u001d\u0010\u0016\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0097\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0097\u0001J1\u0010\u0018\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0097\u0001J\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0097\u0001J-\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u0015H\u0097\u0001J\u0017\u0010\u0007\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 H\u0097\u0001J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0097\u0001J#\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0097\u0001J1\u0010$\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;", "Lde/justsoftware/admin/mybatis/mapper/AppPermissionMapper;", "mapper", "daoSupport", "Lde/justsoftware/admin/mybatis/toolbox/DAOSupport;", "<init>", "(Lde/justsoftware/admin/mybatis/mapper/AppPermissionMapper;Lde/justsoftware/admin/mybatis/toolbox/DAOSupport;)V", "forEach", "", "consumer", "Lkotlin/Function1;", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "Lkotlin/ParameterName;", "name", "appPermission", "delete", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "grantee", "Lde/justsoftware/admin/id/UserId;", "deleteAll", "deleteAllForGrantee", "deleteOne", "granteeId", "role", "Lde/justsoftware/admin/model/Role;", "findBy", "", "findByTenantIdAndAppAndGranteeId", "resultHandler", "Lorg/apache/ibatis/session/ResultHandler;", "getAllForGrantee", "", "getMany", "insert", "admin-service"})
public class AppPermissionRepository
implements AppPermissionMapper {
    @NotNull
    private final AppPermissionMapper mapper;
    @NotNull
    private final DAOSupport daoSupport;

    public AppPermissionRepository(@NotNull AppPermissionMapper mapper, @NotNull DAOSupport daoSupport) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)daoSupport, (String)"daoSupport");
        this.mapper = mapper;
        this.daoSupport = daoSupport;
    }

    public void forEach(@NotNull Function1<? super AppPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.daoSupport.forAll(arg_0 -> AppPermissionRepository.forEach$lambda$0(consumer, arg_0), arg_0 -> ((AppPermissionMapper)this.mapper).forEach(arg_0));
    }

    @Insert(value={"<script>\n\n        <if test=\"_databaseId == 'POSTGRES'\">\n            INSERT INTO app_permission (tenant_id, app, grantee, role)\n                VALUES (\n                    #{tenantId},\n                    #{app},\n                    #{grantee, javaType=de.justsoftware.admin.id.UserId},\n                    #{role}\n                )\n            ON CONFLICT(tenant_id, app, grantee, role)\n                DO NOTHING\n        </if>\n\n        <if test=\"_databaseId == 'ORACLE'\">\n            MERGE INTO app_permission p USING (\n                SELECT\n                    #{tenantId} as tenantId,\n                    #{app} as app,\n                    #{grantee, javaType=de.justsoftware.admin.id.UserId} as grantee,\n                    #{role} as role\n                from dual\n            ) t\n            ON (t.tenantId = p.tenant_id AND t.app = p.app AND t.grantee = p.grantee AND t.role = p.role)\n            WHEN NOT MATCHED THEN\n                INSERT (tenant_id, app, grantee, role)\n                VALUES (\n                    #{tenantId},\n                    #{app},\n                    #{grantee, javaType=de.justsoftware.admin.id.UserId},\n                    #{role}\n                )\n        </if>\n\n        </script>\n        "})
    public void insert(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app, @Param(value="grantee") @NotNull UserId grantee, @Param(value="role") @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.mapper.insert(tenantId, app, grantee, role);
    }

    @Delete(value={"\n        DELETE FROM app_permission\n        WHERE tenant_id = #{tenantId}\n        AND app = #{app}\n        AND grantee = #{grantee, javaType=de.justsoftware.admin.id.UserId}\n        AND role = #{role}\n        "})
    public void deleteOne(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app, @Param(value="grantee") @NotNull UserId granteeId, @Param(value="role") @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.mapper.deleteOne(tenantId, app, granteeId, role);
    }

    @Select(value={"\n        SELECT * FROM app_permission\n        WHERE tenant_id = #{tenantId}\n        AND app = #{app}\n        "})
    @ConstructorArgs(value={@Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="app", javaType=CoreApp.class), @Arg(column="grantee", javaType=UserId.class), @Arg(column="role", javaType=Role.class)})
    @NotNull
    public Set<AppPermission> getMany(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return this.mapper.getMany(tenantId, app);
    }

    @Select(value={"\n        SELECT * FROM app_permission\n        WHERE tenant_id = #{tenantId}\n        AND app = #{app}\n        AND grantee = #{grantee, javaType=de.justsoftware.admin.id.UserId}\n        "})
    @ConstructorArgs(value={@Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="app", javaType=CoreApp.class), @Arg(column="grantee", javaType=UserId.class), @Arg(column="role", javaType=Role.class)})
    @NotNull
    public Set<AppPermission> findByTenantIdAndAppAndGranteeId(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app, @Param(value="grantee") @NotNull UserId granteeId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        return this.mapper.findByTenantIdAndAppAndGranteeId(tenantId, app, granteeId);
    }

    @Select(value={"\n        SELECT * FROM app_permission\n        WHERE grantee = #{grantee, javaType=de.justsoftware.admin.id.UserId}\n        "})
    @ConstructorArgs(value={@Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="app", javaType=CoreApp.class), @Arg(column="grantee", javaType=UserId.class), @Arg(column="role", javaType=Role.class)})
    @NotNull
    public List<AppPermission> getAllForGrantee(@Param(value="grantee") @NotNull UserId grantee) {
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        return this.mapper.getAllForGrantee(grantee);
    }

    @Delete(value={"\n        DELETE FROM app_permission\n        WHERE tenant_id = #{tenantId}\n        AND app = #{app}\n        AND grantee = #{grantee, javaType=de.justsoftware.admin.id.UserId}\n        "})
    public void delete(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app, @Param(value="grantee") @NotNull UserId grantee) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        this.mapper.delete(tenantId, app, grantee);
    }

    @Delete(value={"\n        DELETE FROM app_permission WHERE tenant_id = #{tenantId} AND app = #{app}\n        "})
    public void deleteAll(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="app") @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.mapper.deleteAll(tenantId, app);
    }

    @Delete(value={"\n        DELETE FROM app_permission\n        WHERE grantee = #{grantee, javaType=de.justsoftware.admin.id.UserId}\n        "})
    public void deleteAllForGrantee(@Param(value="grantee") @NotNull UserId grantee) {
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        this.mapper.deleteAllForGrantee(grantee);
    }

    @Select(value={"SELECT * FROM app_permission WHERE tenant_id = #{tenantId}"})
    @NotNull
    public Set<AppPermission> findBy(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.mapper.findBy(tenantId);
    }

    @Select(value={"SELECT * FROM app_permission"})
    @ConstructorArgs(value={@Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="app", javaType=CoreApp.class), @Arg(column="grantee", javaType=UserId.class), @Arg(column="role", javaType=Role.class)})
    @ResultType(value=AppPermission.class)
    public void forEach(@NotNull ResultHandler<AppPermission> resultHandler) {
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        this.mapper.forEach(resultHandler);
    }

    private static final void forEach$lambda$0(Function1 $tmp0, AppPermission p0) {
        $tmp0.invoke((Object)p0);
    }
}

