/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.permission;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.permission.PermissionConnectorKt;
import de.justsoftware.admin.id.ItemId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0012J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/admin/connector/permission/PermissionConnector;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "<init>", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "mayManage", "", "item", "Lde/justsoftware/admin/id/ItemId;", "userId", "Lde/justsoftware/admin/id/UserId;", "isSuperAdmin", "checkAllReaders", "", "itemId", "userIds", "", "", "items", "mayManageResults", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPermissionConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/admin/connector/permission/PermissionConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,59:1\n1740#2,3:60\n1563#2:63\n1634#2,3:64\n1252#2,4:69\n1563#2:73\n1634#2,3:74\n1252#2,4:79\n1252#2,4:85\n465#3:67\n415#3:68\n480#3:77\n426#3:78\n465#3:83\n415#3:84\n*S KotlinDebug\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/admin/connector/permission/PermissionConnector\n*L\n29#1:60,3\n35#1:63\n35#1:64,3\n45#1:69,4\n49#1:73\n49#1:74,3\n52#1:79,4\n53#1:85,4\n45#1:67\n45#1:68\n52#1:77\n52#1:78\n53#1:83\n53#1:84\n*E\n"})
public class PermissionConnector {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;

    public PermissionConnector(@NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.permissionRequestConnector = permissionRequestConnector;
    }

    public boolean mayManage(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayManage((Collection)CollectionsKt.listOf((Object)item), userId).values());
    }

    public boolean isSuperAdmin(@NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.SUPERADMIN), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkAllReaders(@NotNull ItemId itemId, @NotNull Collection<? extends UserId> userIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable $this$map$iv = userIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.toTypedString()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)itemId.toTypedString()), granteeRoles)) {
            boolean bl = false;
            throw new NotAllowedException("Not all userIds '" + userIds + "' may read '" + itemId + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, Boolean> mayManage(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.mayManageResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayManageResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.manage((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.access$toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }
}

