/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.drive;

import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.drive.DriveSettings;
import de.justsoftware.admin.connector.drive.exceptions.DriveApiException;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "", "driveInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "replaceFile", "", "oldFile", "Lde/justsoftware/admin/id/DocumentId;", "newFile", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "deleteFile", "documentId", "user", "addFile", "userId", "getDriveSettings", "Lde/justsoftware/admin/connector/drive/DriveSettings;", "setDrivePublicLinksEnabled", "enabled", "", "setAntivirusEnabled", "reindexDriveMetadata", "runDriveHistoryCompactionJob", "Companion", "admin-service"})
public class DriveApiConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestClient restClient;
    @NotNull
    private static final Logger log;

    public DriveApiConnector(@Value(value="${just.drive.internal}") @NotNull String driveInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor authInterceptor) {
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        this.driveInternalUrl = driveInternalUrl;
        RestClient restClient = restClientBuilder.baseUrl(this.driveInternalUrl).requestInterceptor(authInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    public void replaceFile(@Nullable DocumentId oldFile, @NotNull DocumentId newFile, @NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.deleteFile(oldFile, profileId);
        this.addFile(newFile, tenantId, profileId);
    }

    public void deleteFile(@Nullable DocumentId documentId, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (documentId == null) {
            return;
        }
        try {
            ResponseEntity responseEntity = this.getRestClient().delete().uri(this.driveInternalUrl + "/file/" + documentId.getValue() + "/delete?deletingUser=" + user.getValue(), new Object[0]).retrieve().toBodilessEntity();
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (HttpClientErrorException ex) {
            log.warn("deleteFile failed client error: '" + ex.getResponseBodyAsString() + "'!");
        }
        catch (HttpServerErrorException ex) {
            log.warn("deleteFile failed server error: '" + ex.getResponseBodyAsString() + "'!");
        }
    }

    @NotNull
    public DocumentId addFile(@NotNull DocumentId documentId, @NotNull TenantId tenantId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)tenantId.toTypedString()), TuplesKt.to((Object)"tempFileIds", (Object)SetsKt.setOf((Object)documentId.getValue())), TuplesKt.to((Object)"ownerId", (Object)userId.getValue())};
        ResponseEntity responseEntity = ((RestClient.RequestBodySpec)this.getRestClient().post().uri(this.driveInternalUrl + "/tmp/move", new Object[0])).body((Object)MapsKt.mapOf((Pair[])pairArray)).retrieve().onStatus(DriveApiConnector::addFile$lambda$0, (arg_0, arg_1) -> DriveApiConnector.addFile$lambda$1(documentId, arg_0, arg_1)).toEntity(Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"toEntity(...)");
        ResponseEntity response = responseEntity;
        Object object = (Map)response.getBody();
        Object firstResult = object != null && (object = object.values()) != null ? CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : null;
        Intrinsics.checkNotNull((Object)firstResult, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>");
        String responseId = String.valueOf(((Map)((LinkedHashMap)firstResult)).get("id"));
        return DocumentId.Companion.fromStringValue(responseId);
    }

    @NotNull
    public DriveSettings getDriveSettings(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DriveSettings defaultSettings = new DriveSettings(tenantId, false, false);
        DriveSettings driveSettings = (DriveSettings)this.getRestClient().get().uri("/settings", new Object[0]).retrieve().body(DriveSettings.class);
        if (driveSettings == null) {
            driveSettings = defaultSettings;
        }
        return driveSettings;
    }

    public void setDrivePublicLinksEnabled(boolean enabled) {
        ((RestClient.RequestBodySpec)this.getRestClient().patch().uri("/settings/publicLinks/" + enabled, new Object[0])).retrieve().toBodilessEntity();
    }

    public void setAntivirusEnabled(boolean enabled) {
        ((RestClient.RequestBodySpec)this.getRestClient().patch().uri("/settings/antivirus/" + enabled, new Object[0])).retrieve().toBodilessEntity();
    }

    public boolean reindexDriveMetadata() {
        return ((RestClient.RequestBodySpec)this.getRestClient().post().uri("/reindexMetadata", new Object[0])).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    public boolean runDriveHistoryCompactionJob() {
        return ((RestClient.RequestBodySpec)this.getRestClient().post().uri("/runDriveHistoryCompactionJob", new Object[0])).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    private static final boolean addFile$lambda$0(HttpStatusCode status) {
        return !status.is2xxSuccessful();
    }

    private static final void addFile$lambda$1(DocumentId $documentId, HttpRequest request, ClientHttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpStatusCode httpStatusCode = response.getStatusCode();
        Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
        throw new DriveApiException($documentId, httpStatusCode);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DriveApiConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

