/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.auth;

import de.justsoftware.admin.connector.auth.AuthApiToken;
import de.justsoftware.admin.connector.auth.AuthSettings;
import de.justsoftware.admin.connector.auth.PublicApiClient;
import de.justsoftware.admin.connector.auth.PublicApiClientWithSecret;
import de.justsoftware.admin.graphql.generated.types.AddPublicApiClientInput;
import de.justsoftware.admin.graphql.generated.types.UpdatePublicApiClientInput;
import de.justsoftware.admin.id.TenantId;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lde/justsoftware/admin/connector/auth/AuthConnector;", "", "authInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "getScimToken", "Lde/justsoftware/admin/connector/auth/AuthApiToken;", "generateScimToken", "deleteScimToken", "", "setMfaMandatory", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "mfaMandatory", "getMfaMandatory", "(Lde/justsoftware/admin/id/TenantId;)Ljava/lang/Boolean;", "getPublicApiClients", "", "Lde/justsoftware/admin/connector/auth/PublicApiClient;", "createPublicApiClient", "Lde/justsoftware/admin/connector/auth/PublicApiClientWithSecret;", "input", "Lde/justsoftware/admin/graphql/generated/types/AddPublicApiClientInput;", "updatePublicApiClient", "Lde/justsoftware/admin/graphql/generated/types/UpdatePublicApiClientInput;", "updatePublicApiClientSecret", "id", "deletePublicApiClient", "clientId", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAuthConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthConnector.kt\nde/justsoftware/admin/connector/auth/AuthConnector\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,108:1\n43#2:109\n43#2:110\n43#2:111\n43#2:112\n43#2:113\n*S KotlinDebug\n*F\n+ 1 AuthConnector.kt\nde/justsoftware/admin/connector/auth/AuthConnector\n*L\n58#1:109\n66#1:110\n75#1:111\n83#1:112\n90#1:113\n*E\n"})
public class AuthConnector {
    @NotNull
    private final RestClient restClient;

    public AuthConnector(@Value(value="${just.auth.internal}") @NotNull String authInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor authInterceptor) {
        Intrinsics.checkNotNullParameter((Object)authInternalUrl, (String)"authInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        RestClient restClient = restClientBuilder.baseUrl(authInternalUrl).requestInterceptor(authInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @Nullable
    public AuthApiToken getScimToken() {
        return (AuthApiToken)this.getRestClient().get().uri("/scim/token", new Object[0]).retrieve().toEntity(AuthApiToken.class).getBody();
    }

    @NotNull
    public AuthApiToken generateScimToken() {
        AuthApiToken authApiToken = (AuthApiToken)((RestClient.RequestBodySpec)this.getRestClient().post().uri("/scim/token", new Object[0])).retrieve().toEntity(AuthApiToken.class).getBody();
        if (authApiToken == null) {
            throw new IllegalStateException("No response from Auth server".toString());
        }
        return authApiToken;
    }

    public boolean deleteScimToken() {
        this.getRestClient().delete().uri("/scim/token", new Object[0]).retrieve().toBodilessEntity();
        return true;
    }

    public void setMfaMandatory(@NotNull TenantId tenantId, boolean mfaMandatory) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ((RestClient.RequestBodySpec)this.getRestClient().post().uri("/settings/" + tenantId + "/mfaMandatory/" + mfaMandatory, new Object[0])).contentType(MediaType.APPLICATION_JSON).retrieve().toBodilessEntity();
    }

    @Nullable
    public Boolean getMfaMandatory(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = this.getRestClient().get().uri("/settings/" + tenantId, new Object[0]).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        AuthSettings authSettings = (AuthSettings)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return authSettings != null ? Boolean.valueOf(authSettings.getMfaMandatory()) : null;
    }

    @NotNull
    public List<PublicApiClient> getPublicApiClients() {
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = this.getRestClient().get().uri("/publicApi/clients", new Object[0]).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        List list = (List)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public PublicApiClientWithSecret createPublicApiClient(@NotNull AddPublicApiClientInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri("/publicApi/client", new Object[0])).body((Object)input).accept(mediaTypeArray)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        PublicApiClientWithSecret publicApiClientWithSecret = (PublicApiClientWithSecret)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (publicApiClientWithSecret == null) {
            throw new IllegalStateException("No response from Auth server".toString());
        }
        return publicApiClientWithSecret;
    }

    @NotNull
    public PublicApiClient updatePublicApiClient(@NotNull UpdatePublicApiClientInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri("/publicApi/client/" + input.getId(), new Object[0])).body((Object)input).accept(mediaTypeArray)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        PublicApiClient publicApiClient = (PublicApiClient)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (publicApiClient == null) {
            throw new IllegalStateException("No response from Auth server".toString());
        }
        return publicApiClient;
    }

    @NotNull
    public PublicApiClientWithSecret updatePublicApiClientSecret(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().put().uri("/publicApi/client/" + id + "/generateNewSecret", new Object[0])).accept(mediaTypeArray)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        PublicApiClientWithSecret publicApiClientWithSecret = (PublicApiClientWithSecret)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (publicApiClientWithSecret == null) {
            throw new IllegalStateException("No response from Auth server".toString());
        }
        return publicApiClientWithSecret;
    }

    public boolean deletePublicApiClient(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.getRestClient().delete().uri(arg_0 -> AuthConnector.deletePublicApiClient$lambda$0(clientId, arg_0)).retrieve().toBodilessEntity();
        return true;
    }

    private static final URI deletePublicApiClient$lambda$0(String $clientId, UriBuilder it) {
        Object[] objectArray = new Object[]{$clientId};
        return it.path("/publicApi/client").queryParam("clientId", objectArray).build(new Object[0]);
    }
}

