/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web.drive;

import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.drive.DriveSettings;
import de.justsoftware.admin.graphql.generated.types.DriveSettingsInput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/application/web/drive/DriveSettingsApplicationService;", "", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "<init>", "(Lde/justsoftware/admin/connector/drive/DriveApiConnector;)V", "getSettings", "Lde/justsoftware/admin/connector/drive/DriveSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "updateSettings", "", "input", "Lde/justsoftware/admin/graphql/generated/types/DriveSettingsInput;", "admin-service"})
public class DriveSettingsApplicationService {
    @NotNull
    private final DriveApiConnector driveApiConnector;

    public DriveSettingsApplicationService(@NotNull DriveApiConnector driveApiConnector) {
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        this.driveApiConnector = driveApiConnector;
    }

    @NotNull
    public DriveSettings getSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        return this.driveApiConnector.getDriveSettings(authContext.getNonNullTenantId());
    }

    public void updateSettings(@NotNull DriveSettingsInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        if (input.getPublicLinksEnabled() != null) {
            this.driveApiConnector.setDrivePublicLinksEnabled(input.getPublicLinksEnabled().booleanValue());
        }
        if (input.getAntivirusEnabled() != null) {
            this.driveApiConnector.setAntivirusEnabled(input.getAntivirusEnabled().booleanValue());
        }
    }
}

