/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.internal.coverage.j2d.DeferredProperty;
import org.apache.sis.internal.coverage.j2d.TiledImage;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.TiledDeferredImage;
import org.apache.sis.internal.storage.TiledGridResource;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.util.GenericName;

public abstract class TiledGridCoverage
extends GridCoverage {
    protected static final int BIDIMENSIONAL = 2;
    protected static final int X_DIMENSION = 0;
    protected static final int Y_DIMENSION = 1;
    private final GridExtent readExtent;
    private final boolean forceTileSize;
    private final int[] tileSize;
    private final int[] tileStrides;
    private final int indexOfFirstTile;
    private final long[] tmcOfFirstTile;
    private final int[] subsampling;
    private final int[] subsamplingOffsets;
    protected final int[] includedBands;
    private final WeakValueHashMap<TiledGridResource.CacheKey, Raster> rasters;
    protected final SampleModel model;
    protected final ColorModel colors;
    protected final Number fillValue;
    private final boolean deferredTileReading;

    protected TiledGridCoverage(TiledGridResource.Subset subset) {
        super(subset.domain, subset.ranges);
        GridExtent gridExtent = subset.domain.getExtent();
        int n = subset.sourceExtent.getDimension();
        this.deferredTileReading = subset.deferredTileReading();
        this.readExtent = subset.readExtent;
        this.subsampling = subset.subsampling;
        this.subsamplingOffsets = subset.subsamplingOffsets;
        this.includedBands = subset.includedBands;
        this.rasters = subset.cache;
        this.tileSize = subset.tileSize;
        this.tmcOfFirstTile = new long[n];
        this.tileStrides = new int[n];
        int[] nArray = new int[n];
        int n2 = 1;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n3 = this.tileSize[i];
            this.tmcOfFirstTile[i] = Math.floorDiv(this.readExtent.getLow(i), (long)n3);
            this.tileStrides[i] = n2;
            nArray[i] = (int)Math.min((long)((n3 - 1) / this.subsampling[i] + 1), gridExtent.getSize(i));
            l = Math.addExact(l, Math.multiplyExact(this.tmcOfFirstTile[i], (long)n2));
            int n4 = Math.toIntExact(Numerics.ceilDiv(subset.sourceExtent.getSize(i), (long)n3));
            n2 = Math.multiplyExact(n4, n2);
        }
        this.indexOfFirstTile = Math.toIntExact(l);
        SampleModel sampleModel = subset.modelForBandSubset;
        if (sampleModel.getWidth() != nArray[0] || sampleModel.getHeight() != nArray[1]) {
            sampleModel = sampleModel.createCompatibleSampleModel(nArray[0], nArray[1]);
        }
        this.model = sampleModel;
        this.colors = subset.colorsForBandSubset;
        this.fillValue = subset.fillValue;
        this.forceTileSize = nArray[0] * this.subsampling[0] == this.tileSize[0];
    }

    protected abstract GenericName getIdentifier();

    protected Locale getLocale() {
        return null;
    }

    protected final int getTileSize(int n) {
        return this.tileSize[n];
    }

    protected final int getSubsampling(int n) {
        return this.subsampling[n];
    }

    private long toFullResolution(long l, int n) {
        return Math.addExact(Math.multiplyExact(l, (long)this.subsampling[n]), (long)this.subsamplingOffsets[n]);
    }

    private long toSubsampledPixel(long l, int n) {
        return Math.floorDiv(Math.subtractExact(l, (long)this.subsamplingOffsets[n]), (long)this.subsampling[n]);
    }

    private long toTileMatrixCoordinate(long l, int n) {
        return Math.floorDiv(this.toFullResolution(l, n), (long)this.tileSize[n]);
    }

    protected final int getPixelsPerElement() {
        return TiledGridCoverage.getPixelsPerElement(this.model);
    }

    static int getPixelsPerElement(SampleModel sampleModel) {
        int n;
        int n2;
        int n3;
        if (sampleModel instanceof MultiPixelPackedSampleModel && (n3 = (n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType())) / (n = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride())) > 0) {
            return n3;
        }
        return 1;
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        PlanarImage planarImage;
        GridExtent gridExtent2 = this.getGridGeometry().getExtent();
        int n = gridExtent2.getDimension();
        if (gridExtent == null) {
            gridExtent = gridExtent2;
        } else {
            int n2 = gridExtent.getDimension();
            if (n2 != n) {
                throw new MismatchedDimensionException(Errors.format((short)81, "sliceExtent", n, n2));
            }
        }
        int[] nArray = gridExtent.getSubspaceDimensions(2);
        if (nArray[1] != 1) {
            throw new UnsupportedOperationException("Non-horizontal slices not yet implemented.");
        }
        try {
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            for (int i = 0; i < n; ++i) {
                long l;
                long l2 = gridExtent2.getLow(i);
                long l3 = gridExtent2.getHigh(i);
                long l4 = gridExtent.getLow(i);
                long l5 = gridExtent.getHigh(i);
                long l6 = Math.incrementExact(this.toTileMatrixCoordinate(Math.min(l5, l3), i));
                if (l6 <= (l = this.toTileMatrixCoordinate(Math.max(l4, l2), i))) {
                    String string = Errors.getResources(this.getLocale()).getString((short)60, l4, l5);
                    if (l4 > l5) {
                        throw new IllegalArgumentException(string);
                    }
                    throw new DisjointExtentException(string);
                }
                long l7 = Math.max(this.toSubsampledPixel(Math.multiplyExact(l, (long)this.tileSize[i]), i), l2);
                long l8 = Math.incrementExact(Math.min(this.toSubsampledPixel(Math.decrementExact(Math.multiplyExact(l6, (long)this.tileSize[i])), i), l3));
                nArray5[i] = Math.toIntExact(Math.subtractExact(l8, l7));
                nArray4[i] = Math.toIntExact(Math.subtractExact(l7, l4));
                nArray2[i] = Math.toIntExact(Math.subtractExact(l, this.tmcOfFirstTile[i]));
                nArray3[i] = Math.toIntExact(Math.subtractExact(l6, this.tmcOfFirstTile[i]));
            }
            AOI aOI = new AOI(nArray2, nArray3, nArray4, n);
            Map<String, Object> map = DeferredProperty.forGridGeometry(this.getGridGeometry(), nArray);
            if (this.deferredTileReading) {
                planarImage = new TiledDeferredImage(nArray5, nArray2, map, aOI);
            } else {
                Raster[] rasterArray = this.readTiles(aOI);
                planarImage = new TiledImage(map, this.colors, nArray5[0], nArray5[1], nArray2[0], nArray2[1], rasterArray);
            }
        }
        catch (Exception exception) {
            throw new CannotEvaluateException(Resources.forLocale(this.getLocale()).getString((short)61, this.getIdentifier().toFullyQualifiedName()), exception);
        }
        return planarImage;
    }

    private TiledGridResource.CacheKey createCacheKey(int n) {
        return new TiledGridResource.CacheKey(n, this.includedBands, this.subsampling, this.subsamplingOffsets);
    }

    protected abstract Raster[] readTiles(AOI var1) throws IOException, DataStoreException;

    protected final class AOI {
        public final int tileCountInQuery;
        private final int[] tileLower;
        private final int[] tileUpper;
        private final int[] offsetAOI;
        private final int[] tmcInSubset;
        private final long[] tileOffsetFull;
        private int indexInResultArray;
        private int indexInTileVector;

        AOI(int[] nArray, int[] nArray2, int[] nArray3, int n) {
            this.tileLower = nArray;
            this.tileUpper = nArray2;
            this.offsetAOI = nArray3;
            this.tileOffsetFull = new long[nArray3.length];
            this.indexInTileVector = TiledGridCoverage.this.indexOfFirstTile;
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                int n4 = Math.subtractExact(nArray2[i], n3);
                this.indexInTileVector = Math.addExact(this.indexInTileVector, Math.multiplyExact(TiledGridCoverage.this.tileStrides[i], n3));
                n2 = Math.multiplyExact(n2, n4);
                this.tileOffsetFull[i] = JDK9.multiplyFull(nArray3[i], TiledGridCoverage.this.subsampling[i]);
                int n5 = Math.addExact(nArray3[i], Math.multiplyExact(TiledGridCoverage.this.tileSize[i], n4));
                assert (n5 > Math.max(nArray3[i], 0)) : n5;
            }
            this.tileCountInQuery = n2;
            this.tmcInSubset = (int[])nArray.clone();
        }

        public AOI subset(int[] nArray, int[] nArray2) {
            int n;
            int[] nArray3 = (int[])this.offsetAOI.clone();
            int[] nArray4 = (int[])this.tileLower.clone();
            int n2 = Math.min(nArray.length, nArray4.length);
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                n = nArray4[n2];
                if (n3 <= n) continue;
                nArray4[n2] = n3;
                nArray3[n2] = Math.addExact(nArray3[n2], Numerics.ceilDiv(Math.multiplyExact(n3 - n, TiledGridCoverage.this.tileSize[n2]), TiledGridCoverage.this.subsampling[n2]));
            }
            int[] nArray5 = (int[])this.tileUpper.clone();
            n = Math.min(nArray2.length, nArray5.length);
            while (--n >= 0) {
                nArray5[n] = Math.max(nArray4[n], Math.min(nArray5[n], nArray2[n]));
            }
            return new AOI(nArray4, nArray5, nArray3, nArray3.length);
        }

        final TiledGridCoverage getCoverage() {
            return TiledGridCoverage.this;
        }

        public final int getIndexInResultArray() {
            return this.indexInResultArray;
        }

        public Raster getCachedTile() {
            Raster raster = (Raster)TiledGridCoverage.this.rasters.get(TiledGridCoverage.this.createCacheKey(this.indexInTileVector));
            if (raster != null) {
                int n = this.getTileOrigin(0);
                int n2 = this.getTileOrigin(1);
                if (TiledGridCoverage.this.model.equals(raster.getSampleModel())) {
                    if (raster.getMinX() == n && raster.getMinY() == n2) {
                        return raster;
                    }
                    return raster.createTranslatedChild(n, n2);
                }
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel.getWidth() == TiledGridCoverage.this.model.getWidth() && sampleModel.getHeight() == TiledGridCoverage.this.model.getHeight()) {
                    int n3 = raster.getWidth();
                    int n4 = raster.getHeight();
                    Raster raster2 = Raster.createRaster(TiledGridCoverage.this.model, raster.getDataBuffer(), new Point(n, n2));
                    if (raster2.getWidth() != n3 || raster2.getHeight() != n4) {
                        raster2 = raster2.createChild(n, n2, n3, n4, n, n2, null);
                    }
                    return raster2;
                }
            }
            return null;
        }

        final int getTileOrigin(int n) {
            return Math.toIntExact(Numerics.ceilDiv(this.tileOffsetFull[n], (long)TiledGridCoverage.this.subsampling[n]));
        }

        public boolean next() {
            if (++this.indexInResultArray >= this.tileCountInQuery) {
                return false;
            }
            for (int i = 0; i < this.tmcInSubset.length; ++i) {
                this.indexInTileVector += TiledGridCoverage.this.tileStrides[i];
                int n = i;
                this.tmcInSubset[n] = this.tmcInSubset[n] + 1;
                if (this.tmcInSubset[n] < this.tileUpper[i]) {
                    int n2 = i;
                    this.tileOffsetFull[n2] = this.tileOffsetFull[n2] + (long)TiledGridCoverage.this.tileSize[i];
                    break;
                }
                this.indexInTileVector -= (this.tmcInSubset[i] - this.tileLower[i]) * TiledGridCoverage.this.tileStrides[i];
                this.tmcInSubset[i] = this.tileLower[i];
                this.tileOffsetFull[i] = JDK9.multiplyFull(this.offsetAOI[i], TiledGridCoverage.this.subsampling[i]);
            }
            return true;
        }
    }

    protected static class Snapshot {
        private final TiledGridCoverage coverage;
        private final int[] tmcInSubset;
        public final int indexInResultArray;
        public final int indexInTileVector;
        public final int originX;
        public final int originY;

        public Snapshot(AOI aOI) {
            this.coverage = aOI.getCoverage();
            this.tmcInSubset = (int[])aOI.tmcInSubset.clone();
            this.indexInResultArray = aOI.indexInResultArray;
            this.indexInTileVector = aOI.indexInTileVector;
            this.originX = aOI.getTileOrigin(0);
            this.originY = aOI.getTileOrigin(1);
        }

        public boolean getRegionInsideTile(long[] lArray, long[] lArray2, int[] nArray, int n) {
            System.arraycopy(this.coverage.subsampling, 0, nArray, 0, n);
            while (--n >= 0) {
                int n2;
                int n3 = this.coverage.tileSize[n];
                long l = Math.addExact(this.coverage.tmcOfFirstTile[n], (long)this.tmcInSubset[n]);
                long l2 = Math.multiplyExact(l, (long)n3);
                long l3 = Math.subtractExact(this.coverage.readExtent.getLow(n), l2);
                long l4 = Math.min(Math.addExact(l3, this.coverage.readExtent.getSize(n)), (long)n3);
                if (l3 < 0L && (l3 %= (long)(n2 = this.coverage.subsampling[n])) != 0L) {
                    l3 += (long)n2;
                }
                if (l3 >= l4) {
                    return false;
                }
                if (n == 0 && this.coverage.forceTileSize) {
                    l4 = n3;
                }
                lArray[n] = l3;
                lArray2[n] = l4;
            }
            return true;
        }

        public Raster cache(Raster raster) {
            TiledGridResource.CacheKey cacheKey = this.coverage.createCacheKey(this.indexInTileVector);
            Raster raster2 = this.coverage.rasters.put(cacheKey, raster);
            if (raster2 != null && raster2.getSampleModel().equals(raster.getSampleModel()) && raster2.getWidth() == raster.getWidth() && raster2.getHeight() == raster.getHeight() && this.coverage.rasters.replace(cacheKey, raster, raster2)) {
                int n = raster.getMinX();
                int n2 = raster.getMinY();
                if (raster2.getMinX() != n || raster2.getMinY() != n2) {
                    raster2 = raster2.createTranslatedChild(n, n2);
                }
                return raster2;
            }
            return raster;
        }
    }
}

