/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.handler.sql.SolrTable;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.security.PKIAuthenticationPlugin;

class SolrSchema
extends AbstractSchema
implements Closeable {
    final Properties properties;
    final SolrClientCache solrClientCache;
    private volatile boolean isClosed = false;
    private Map<String, RelDataType> schemaCache = new ConcurrentHashMap<String, RelDataType>();

    SolrSchema(Properties properties, SolrClientCache solrClientCache) {
        this.properties = properties;
        this.solrClientCache = solrClientCache;
    }

    public SolrClientCache getSolrClientCache() {
        return this.solrClientCache;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected Map<String, Table> getTableMap() {
        String zk = this.properties.getProperty("zk");
        CloudSolrClient cloudSolrClient = this.solrClientCache.getCloudSolrClient(zk);
        ClusterState clusterState = cloudSolrClient.getClusterState();
        HashMap<String, SolrTable> builder = new HashMap<String, SolrTable>();
        Set collections = clusterState.getCollectionsMap().keySet();
        for (String collection : collections) {
            builder.put(collection, new SolrTable(this, collection));
        }
        Aliases aliases = ZkStateReader.from((CloudSolrClient)cloudSolrClient).getAliases();
        for (String alias : aliases.getCollectionAliasListMap().keySet()) {
            if (collections.contains(alias)) continue;
            builder.put(alias, new SolrTable(this, alias));
        }
        return Map.copyOf(builder);
    }

    private Map<String, LukeResponse.FieldInfo> getFieldInfo(String collection) {
        String zk = this.properties.getProperty("zk");
        PKIAuthenticationPlugin.withServerIdentity((boolean)true);
        try {
            LukeRequest lukeRequest = new LukeRequest();
            lukeRequest.setNumTerms(0);
            Map map = ((LukeResponse)lukeRequest.process((SolrClient)this.solrClientCache.getCloudSolrClient(zk), collection)).getFieldInfo();
            return map;
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        finally {
            PKIAuthenticationPlugin.withServerIdentity((boolean)false);
        }
    }

    private LukeResponse getSchema(String collection) {
        String zk = this.properties.getProperty("zk");
        PKIAuthenticationPlugin.withServerIdentity((boolean)true);
        try {
            LukeRequest lukeRequest = new LukeRequest();
            lukeRequest.setShowSchema(true);
            lukeRequest.setNumTerms(0);
            LukeResponse lukeResponse = (LukeResponse)lukeRequest.process((SolrClient)this.solrClientCache.getCloudSolrClient(zk), collection);
            return lukeResponse;
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        finally {
            PKIAuthenticationPlugin.withServerIdentity((boolean)false);
        }
    }

    private boolean isStoredIndexedOrDocValues(EnumSet<FieldFlag> flags) {
        return flags != null && (flags.contains(FieldFlag.DOC_VALUES) || flags.contains(FieldFlag.STORED) || flags.contains(FieldFlag.INDEXED));
    }

    private EnumSet<FieldFlag> getFieldFlags(LukeResponse.FieldInfo luceneFieldInfo) {
        String fieldSchema;
        EnumSet flags = luceneFieldInfo.getSchemaFlags();
        if (flags == null && (fieldSchema = luceneFieldInfo.getSchema()) != null) {
            flags = LukeResponse.FieldInfo.parseFlags((String)fieldSchema);
        }
        return flags;
    }

    RelProtoDataType getRelDataType(String collection) {
        return RelDataTypeImpl.proto((RelDataType)this.getRowSchema(collection));
    }

    RelDataType getRowSchema(String collection) {
        return this.schemaCache.computeIfAbsent(collection, this::buildRowSchema);
    }

    RelDataType buildRowSchema(String collection) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        Map<String, LukeResponse.FieldInfo> fieldsInUseMap = this.getFieldInfo(collection);
        LukeResponse schema = this.getSchema(collection);
        Map<String, LukeResponse.FieldInfo> storedFields = schema.getFieldInfo().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map combinedFields = Stream.of(fieldsInUseMap, storedFields).flatMap(map -> map.entrySet().stream()).filter(e -> this.isStoredIndexedOrDocValues(this.getFieldFlags((LukeResponse.FieldInfo)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, TreeMap::new));
        HashMap javaClassForTypeMap = new HashMap();
        for (Map.Entry entry : combinedFields.entrySet()) {
            RelDataType type;
            LukeResponse.FieldInfo luceneFieldInfo = (LukeResponse.FieldInfo)entry.getValue();
            String luceneFieldType = luceneFieldInfo.getType();
            if (luceneFieldType == null) continue;
            EnumSet<FieldFlag> flags = this.getFieldFlags(luceneFieldInfo);
            if (flags != null && flags.contains(FieldFlag.MULTI_VALUED)) {
                type = typeFactory.createSqlType(SqlTypeName.ANY);
            } else {
                switch (luceneFieldType) {
                    case "string": {
                        type = typeFactory.createJavaType(String.class);
                        break;
                    }
                    case "tint": 
                    case "tlong": 
                    case "int": 
                    case "long": 
                    case "pint": 
                    case "plong": {
                        type = typeFactory.createJavaType(Long.class);
                        break;
                    }
                    case "tfloat": 
                    case "tdouble": 
                    case "float": 
                    case "double": 
                    case "pfloat": 
                    case "pdouble": {
                        type = typeFactory.createJavaType(Double.class);
                        break;
                    }
                    case "pdate": {
                        type = typeFactory.createJavaType(Date.class);
                        break;
                    }
                    default: {
                        Class<?> javaClass = (Class<?>)javaClassForTypeMap.get(luceneFieldType);
                        if (javaClass == null) {
                            javaClass = this.guessJavaClassForFieldType((LukeResponse.FieldTypeInfo)schema.getFieldTypeInfo().get(luceneFieldType));
                            javaClassForTypeMap.put(luceneFieldType, javaClass);
                        }
                        type = typeFactory.createJavaType((Class)javaClass);
                    }
                }
            }
            fieldInfo.add((String)entry.getKey(), type).nullable(true);
        }
        fieldInfo.add("_query_", typeFactory.createJavaType(String.class));
        fieldInfo.add("score", typeFactory.createJavaType(Double.class));
        return fieldInfo.build();
    }

    private Class<?> guessJavaClassForFieldType(LukeResponse.FieldTypeInfo typeInfo) {
        Class typeClass = null;
        if (typeInfo != null && !typeInfo.isTokenized() && typeInfo.getClassName() != null) {
            try {
                Class<?> fieldTypeClass = this.getClass().getClassLoader().loadClass(typeInfo.getClassName());
                if (IntValueFieldType.class.isAssignableFrom(fieldTypeClass) || LongValueFieldType.class.isAssignableFrom(fieldTypeClass)) {
                    typeClass = Long.class;
                } else if (FloatValueFieldType.class.isAssignableFrom(fieldTypeClass) || DoubleValueFieldType.class.isAssignableFrom(fieldTypeClass)) {
                    typeClass = Double.class;
                } else if (DateValueFieldType.class.isAssignableFrom(fieldTypeClass)) {
                    typeClass = Date.class;
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return typeClass != null ? typeClass : String.class;
    }
}

