/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.BitSet;

public class DiversifyingNearestChildrenKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BitSetProducer parentsFilter;

    public DiversifyingNearestChildrenKnnCollectorManager(int k, BitSetProducer parentsFilter) {
        this.k = k;
        this.parentsFilter = parentsFilter;
    }

    public DiversifyingNearestChildrenKnnCollector newCollector(int visitedLimit, LeafReaderContext context) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return null;
        }
        return new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, parentBitSet);
    }
}

