/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.util.SolrPluginUtils;

abstract class AbstractMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");

    protected String[] getFieldsFromSchema() {
        Map<String, SchemaField> fieldDefinitions = this.req.getSearcher().getSchema().getFields();
        ArrayList<String> fields = new ArrayList<String>();
        for (Map.Entry<String, SchemaField> entry : fieldDefinitions.entrySet()) {
            if (!entry.getValue().indexed() || !entry.getValue().stored() || entry.getValue().getType().getNumberType() != null) continue;
            fields.add(entry.getKey());
        }
        return fields.toArray(new String[0]);
    }

    AbstractMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    public BooleanQuery exclude(BooleanQuery boostedMLTQuery, Query docIdQuery) {
        BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
        realMLTQuery.add((Query)boostedMLTQuery, BooleanClause.Occur.MUST);
        realMLTQuery.add(docIdQuery, BooleanClause.Occur.MUST_NOT);
        return realMLTQuery.build();
    }

    protected BooleanQuery parseMLTQuery(Supplier<String[]> fieldsFallback, MLTInvoker invoker, Query docIdQuery) throws IOException {
        return this.exclude(this.parseMLTQuery(fieldsFallback, invoker), docIdQuery);
    }

    protected BooleanQuery parseMLTQuery(Supplier<String[]> fieldsFallback, MLTInvoker invoker) throws IOException {
        String[] fieldNames;
        HashMap<String, Float> boostFields = new HashMap<String, Float>();
        MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
        mlt.setMinTermFreq(this.localParams.getInt("mintf", 2));
        mlt.setMinDocFreq(this.localParams.getInt("mindf", 5));
        mlt.setMinWordLen(this.localParams.getInt("minwl", 0));
        mlt.setMaxWordLen(this.localParams.getInt("maxwl", 0));
        mlt.setMaxQueryTerms(this.localParams.getInt("maxqt", 25));
        mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp", 5000));
        mlt.setMaxDocFreq(this.localParams.getInt("maxdf", Integer.MAX_VALUE));
        boolean boost = this.localParams.getBool("boost", false);
        mlt.setBoost(boost);
        mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
        String[] qf = this.localParams.getParams("qf");
        if (qf != null) {
            ArrayList<String> fields = new ArrayList<String>();
            for (String fieldName : qf) {
                String[] strings;
                if (!StrUtils.isNotNullOrEmpty((String)fieldName)) continue;
                for (String string : strings = splitList.split(fieldName)) {
                    if (!StrUtils.isNotNullOrEmpty((String)string)) continue;
                    fields.add(string);
                }
            }
            boostFields.putAll(SolrPluginUtils.parseFieldBoosts(fields.toArray(new String[0])));
            fieldNames = boostFields.keySet().toArray(new String[0]);
        } else {
            fieldNames = fieldsFallback.get();
        }
        if (fieldNames.length < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
        }
        mlt.setFieldNames(fieldNames);
        BooleanQuery rawMLTQuery = (BooleanQuery)invoker.invoke(mlt);
        if (boost && boostFields.size() > 0) {
            BooleanQuery.Builder newQ = new BooleanQuery.Builder();
            newQ.setMinimumNumberShouldMatch(rawMLTQuery.getMinimumNumberShouldMatch());
            for (BooleanClause clause : rawMLTQuery) {
                Float fieldBoost;
                Query q = clause.getQuery();
                float originalBoost = 1.0f;
                if (q instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)q;
                    q = bq.getQuery();
                    originalBoost = bq.getBoost();
                }
                q = (fieldBoost = (Float)boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                newQ.add(q, clause.getOccur());
            }
            return QueryUtils.build(newQ, this);
        }
        return rawMLTQuery;
    }

    @FunctionalInterface
    protected static interface MLTInvoker {
        public Query invoke(MoreLikeThis var1) throws IOException;
    }
}

