/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.QueryTimeout;
import org.apache.solr.request.SolrQueryRequest;

public class TimeAllowedLimit
implements QueryTimeout {
    private final long timeoutAt;

    public TimeAllowedLimit(SolrQueryRequest req) {
        long reqTimeAllowed = req.getParams().getLong("timeAllowed", -1L);
        if (reqTimeAllowed == -1L) {
            throw new IllegalArgumentException("Check for limit with hasTimeLimit(req) before creating a TimeAllowedLimit");
        }
        long timeAllowed = reqTimeAllowed - (long)req.getRequestTimer().getTime();
        long nanosAllowed = TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS);
        this.timeoutAt = System.nanoTime() + nanosAllowed;
    }

    static boolean hasTimeLimit(SolrQueryRequest req) {
        return req.getParams().getLong("timeAllowed", -1L) >= 0L;
    }

    public boolean shouldExit() {
        return this.timeoutAt - System.nanoTime() < 0L;
    }
}

