/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.solr.cli.ApiTool;
import org.apache.solr.cli.AssertTool;
import org.apache.solr.cli.AuthTool;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.ConfigSetDownloadTool;
import org.apache.solr.cli.ConfigSetUploadTool;
import org.apache.solr.cli.ConfigTool;
import org.apache.solr.cli.CreateCollectionTool;
import org.apache.solr.cli.CreateCoreTool;
import org.apache.solr.cli.CreateTool;
import org.apache.solr.cli.DeleteTool;
import org.apache.solr.cli.ExportTool;
import org.apache.solr.cli.HealthcheckTool;
import org.apache.solr.cli.PackageTool;
import org.apache.solr.cli.PostLogsTool;
import org.apache.solr.cli.PostTool;
import org.apache.solr.cli.RunExampleTool;
import org.apache.solr.cli.StatusTool;
import org.apache.solr.cli.Tool;
import org.apache.solr.cli.VersionTool;
import org.apache.solr.cli.ZkCpTool;
import org.apache.solr.cli.ZkLsTool;
import org.apache.solr.cli.ZkMkrootTool;
import org.apache.solr.cli.ZkMvTool;
import org.apache.solr.cli.ZkRmTool;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.StartupLoggingUtils;
import org.apache.solr.util.configuration.SSLConfigurationsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCLI
implements CLIO {
    private static final long MAX_WAIT_FOR_CORE_LOAD_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ZK_HOST = "localhost:9983";
    public static final Option OPTION_ZKHOST = Option.builder((String)"z").argName("HOST").hasArg().required(false).desc("Address of the ZooKeeper ensemble; defaults to: localhost:9983").longOpt("zkHost").build();
    public static final Option OPTION_SOLRURL = Option.builder((String)"solrUrl").argName("HOST").hasArg().required(false).desc("Base Solr URL, which can be used to determine the zkHost if that's not known; defaults to: " + SolrCLI.getDefaultSolrUrl()).build();
    public static final Option OPTION_VERBOSE = Option.builder((String)"verbose").required(false).desc("Enable more verbose command output.").build();
    public static final Option OPTION_RECURSE = Option.builder((String)"recurse").argName("recurse").hasArg().required(false).desc("Recurse (true|false), default is false.").build();
    public static final List<Option> cloudOptions = List.of(OPTION_ZKHOST, Option.builder((String)"c").argName("COLLECTION").hasArg().required(false).desc("Name of collection").longOpt("collection").build(), OPTION_VERBOSE);
    private static final String JSON_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_CONFIG_SET = "_default";
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    public static final List<Option> CREATE_COLLECTION_OPTIONS = List.of(OPTION_ZKHOST, OPTION_SOLRURL, Option.builder((String)"name").argName("NAME").hasArg().required(true).desc("Name of collection to create.").build(), Option.builder((String)"shards").argName("#").hasArg().required(false).desc("Number of shards; default is 1.").build(), Option.builder((String)"replicationFactor").argName("#").hasArg().required(false).desc("Number of copies of each document across the collection (replicas per shard); default is 1.").build(), Option.builder((String)"confdir").argName("NAME").hasArg().required(false).desc("Configuration directory to copy when creating the new collection; default is _default.").build(), Option.builder((String)"confname").argName("NAME").hasArg().required(false).desc("Configuration name; default is the collection name.").build(), Option.builder((String)"configsetsDir").argName("DIR").hasArg().required(true).desc("Path to configsets directory on the local system.").build(), OPTION_VERBOSE);

    public static void exit(int exitStatus) {
        block2: {
            try {
                System.exit(exitStatus);
            }
            catch (SecurityException secExc) {
                if (exitStatus == 0) break block2;
                throw new RuntimeException("SolrCLI failed to exit with status " + exitStatus);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
            CLIO.err("Invalid command-line args! Must pass the name of a tool to run.\nSupported tools:\n");
            SolrCLI.displayToolOptions();
            SolrCLI.exit(1);
        }
        if (Arrays.asList("-v", "-version", "version").contains(args[0])) {
            args[0] = "version";
        }
        SSLConfigurationsFactory.current().init();
        Tool tool = null;
        try {
            tool = SolrCLI.findTool(args);
        }
        catch (IllegalArgumentException iae) {
            CLIO.err(iae.getMessage());
            System.exit(1);
        }
        CommandLine cli = SolrCLI.parseCmdLine(tool.getName(), args, tool.getOptions());
        System.exit(tool.runTool(cli));
    }

    public static Tool findTool(String[] args) throws Exception {
        String toolType = args[0].trim().toLowerCase(Locale.ROOT);
        return SolrCLI.newTool(toolType);
    }

    public static CommandLine parseCmdLine(String toolName, String[] args, List<Option> toolOptions) {
        ArrayList<String> toolArgList = new ArrayList<String>();
        ArrayList<String> dashDList = new ArrayList<String>();
        for (int a = 1; a < args.length; ++a) {
            String arg = args[a];
            if (arg.startsWith("-D")) {
                dashDList.add(arg);
                continue;
            }
            toolArgList.add(arg);
        }
        String[] toolArgs = toolArgList.toArray(new String[0]);
        CommandLine cli = SolrCLI.processCommandLineArgs(toolName, toolOptions, toolArgs);
        List argList = cli.getArgList();
        argList.addAll(dashDList);
        String solrInstallDir = System.getProperty("solr.install.dir");
        if (solrInstallDir != null) {
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "keyStore");
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "trustStore");
        }
        return cli;
    }

    public static String getDefaultSolrUrl() {
        String scheme = EnvUtils.getEnv((String)"SOLR_URL_SCHEME", (String)"http");
        String host = EnvUtils.getEnv((String)"SOLR_TOOL_HOST", (String)"localhost");
        String port = EnvUtils.getEnv((String)"SOLR_PORT", (String)"8983");
        return String.format(Locale.ROOT, "%s://%s:%s", scheme.toLowerCase(Locale.ROOT), host, port);
    }

    protected static void checkSslStoreSysProp(String solrInstallDir, String key) {
        String sysProp = "javax.net.ssl." + key;
        String keyStore = System.getProperty(sysProp);
        if (keyStore == null) {
            return;
        }
        File keyStoreFile = new File(keyStore);
        if (keyStoreFile.isFile()) {
            return;
        }
        keyStoreFile = new File(solrInstallDir, "server/" + keyStore);
        if (keyStoreFile.isFile()) {
            System.setProperty(sysProp, keyStoreFile.getAbsolutePath());
        } else {
            CLIO.err("WARNING: " + sysProp + " file " + keyStore + " not found! https requests to Solr will likely fail; please update your " + sysProp + " setting to use an absolute path.");
        }
    }

    public static void raiseLogLevelUnlessVerbose(CommandLine cli) {
        if (!cli.hasOption(OPTION_VERBOSE.getOpt())) {
            StartupLoggingUtils.changeLogLevel("WARN");
        }
    }

    private static Tool newTool(String toolType) throws Exception {
        if ("healthcheck".equals(toolType)) {
            return new HealthcheckTool();
        }
        if ("status".equals(toolType)) {
            return new StatusTool();
        }
        if ("api".equals(toolType)) {
            return new ApiTool();
        }
        if ("create_collection".equals(toolType)) {
            return new CreateCollectionTool();
        }
        if ("create_core".equals(toolType)) {
            return new CreateCoreTool();
        }
        if ("create".equals(toolType)) {
            return new CreateTool();
        }
        if ("delete".equals(toolType)) {
            return new DeleteTool();
        }
        if ("config".equals(toolType)) {
            return new ConfigTool();
        }
        if ("run_example".equals(toolType)) {
            return new RunExampleTool();
        }
        if ("upconfig".equals(toolType)) {
            return new ConfigSetUploadTool();
        }
        if ("downconfig".equals(toolType)) {
            return new ConfigSetDownloadTool();
        }
        if ("rm".equals(toolType)) {
            return new ZkRmTool();
        }
        if ("mv".equals(toolType)) {
            return new ZkMvTool();
        }
        if ("cp".equals(toolType)) {
            return new ZkCpTool();
        }
        if ("ls".equals(toolType)) {
            return new ZkLsTool();
        }
        if ("mkroot".equals(toolType)) {
            return new ZkMkrootTool();
        }
        if ("assert".equals(toolType)) {
            return new AssertTool();
        }
        if ("auth".equals(toolType)) {
            return new AuthTool();
        }
        if ("export".equals(toolType)) {
            return new ExportTool();
        }
        if ("package".equals(toolType)) {
            return new PackageTool();
        }
        if ("postlogs".equals(toolType)) {
            return new PostLogsTool();
        }
        if ("version".equals(toolType)) {
            return new VersionTool();
        }
        if ("post".equals(toolType)) {
            return new PostTool();
        }
        for (Class<? extends Tool> next : SolrCLI.findToolClassesInPackage("org.apache.solr.util")) {
            Tool tool = next.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!toolType.equals(tool.getName())) continue;
            return tool;
        }
        throw new IllegalArgumentException(toolType + " is not a valid command!");
    }

    private static void displayToolOptions() throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("healthcheck", SolrCLI.getToolOptions(new HealthcheckTool()));
        formatter.printHelp("status", SolrCLI.getToolOptions(new StatusTool()));
        formatter.printHelp("api", SolrCLI.getToolOptions(new ApiTool()));
        formatter.printHelp("create_collection", SolrCLI.getToolOptions(new CreateCollectionTool()));
        formatter.printHelp("create_core", SolrCLI.getToolOptions(new CreateCoreTool()));
        formatter.printHelp("create", SolrCLI.getToolOptions(new CreateTool()));
        formatter.printHelp("delete", SolrCLI.getToolOptions(new DeleteTool()));
        formatter.printHelp("config", SolrCLI.getToolOptions(new ConfigTool()));
        formatter.printHelp("run_example", SolrCLI.getToolOptions(new RunExampleTool()));
        formatter.printHelp("upconfig", SolrCLI.getToolOptions(new ConfigSetUploadTool()));
        formatter.printHelp("downconfig", SolrCLI.getToolOptions(new ConfigSetDownloadTool()));
        formatter.printHelp("rm", SolrCLI.getToolOptions(new ZkRmTool()));
        formatter.printHelp("cp", SolrCLI.getToolOptions(new ZkCpTool()));
        formatter.printHelp("mv", SolrCLI.getToolOptions(new ZkMvTool()));
        formatter.printHelp("ls", SolrCLI.getToolOptions(new ZkLsTool()));
        formatter.printHelp("export", SolrCLI.getToolOptions(new ExportTool()));
        formatter.printHelp("package", SolrCLI.getToolOptions(new PackageTool()));
        List<Class<? extends Tool>> toolClasses = SolrCLI.findToolClassesInPackage("org.apache.solr.util");
        for (Class<? extends Tool> next : toolClasses) {
            Tool tool = next.getConstructor(new Class[0]).newInstance(new Object[0]);
            formatter.printHelp(tool.getName(), SolrCLI.getToolOptions(tool));
        }
    }

    public static Options getToolOptions(Tool tool) {
        Options options = new Options();
        options.addOption("help", false, "Print this message");
        options.addOption(OPTION_VERBOSE);
        List<Option> toolOpts = tool.getOptions();
        for (Option toolOpt : toolOpts) {
            options.addOption(toolOpt);
        }
        return options;
    }

    public static List<Option> joinOptions(List<Option> lhs, List<Option> rhs) {
        if (lhs == null) {
            return rhs == null ? List.of() : rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return Stream.concat(lhs.stream(), rhs.stream()).collect(Collectors.toUnmodifiableList());
    }

    public static CommandLine processCommandLineArgs(String toolName, List<Option> customOptions, String[] args) {
        Options options = new Options();
        options.addOption("help", false, "Print this message");
        options.addOption(OPTION_VERBOSE);
        if (customOptions != null) {
            for (Option customOption : customOptions) {
                options.addOption(customOption);
            }
        }
        CommandLine cli = null;
        try {
            cli = new GnuParser().parse(options, args);
        }
        catch (ParseException exp) {
            boolean hasHelpArg = false;
            if (args != null) {
                for (String arg : args) {
                    if (!"-h".equals(arg) && !"-help".equals(arg)) continue;
                    hasHelpArg = true;
                    break;
                }
            }
            if (!hasHelpArg) {
                CLIO.err("Failed to parse command-line arguments due to: " + exp.getMessage());
                SolrCLI.exit(1);
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(toolName, options);
            SolrCLI.exit(0);
        }
        if (cli.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(toolName, options);
            SolrCLI.exit(0);
        }
        return cli;
    }

    private static List<Class<? extends Tool>> findToolClassesInPackage(String packageName) {
        ArrayList<Class<? extends Tool>> toolClasses = new ArrayList<Class<? extends Tool>>();
        try {
            ClassLoader classLoader = SolrCLI.class.getClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            TreeSet<String> classes = new TreeSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                classes.addAll(SolrCLI.findClasses(resource.getFile(), packageName));
            }
            for (String classInPackage : classes) {
                Class<?> theClass = Class.forName(classInPackage);
                if (!Tool.class.isAssignableFrom(theClass)) continue;
                toolClasses.add(theClass.asSubclass(Tool.class));
            }
        }
        catch (Exception e) {
            log.debug("Failed to find Tool impl classes in {}, due to: ", (Object)packageName, (Object)e);
        }
        return toolClasses;
    }

    private static Set<String> findClasses(String path, String packageName) throws Exception {
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    String className;
                    if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                    classes.add(className);
                }
            }
        }
        return classes;
    }

    public static boolean checkCommunicationError(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        return rootCause instanceof SolrServerException || rootCause instanceof SocketException;
    }

    public static void checkCodeForAuthError(int code) {
        if (code == SolrException.ErrorCode.UNAUTHORIZED.code || code == SolrException.ErrorCode.FORBIDDEN.code) {
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)code), "Solr requires authentication for request. Please supply valid credentials. HTTP code=" + code);
        }
    }

    public static boolean exceptionIsAuthRelated(Exception exc) {
        return exc instanceof SolrException && Arrays.asList(SolrException.ErrorCode.UNAUTHORIZED.code, SolrException.ErrorCode.FORBIDDEN.code).contains(((SolrException)exc).code());
    }

    public static SolrClient getSolrClient(String solrUrl) {
        return ((Http2SolrClient.Builder)new Http2SolrClient.Builder(solrUrl).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS).withMaxConnectionsPerHost(32)).build();
    }

    public static NamedList<Object> postJsonToSolr(SolrClient solrClient, String updatePath, String jsonBody) throws Exception {
        ContentStreamBase.StringStream contentStream = new ContentStreamBase.StringStream(jsonBody);
        contentStream.setContentType(JSON_CONTENT_TYPE);
        ContentStreamUpdateRequest req = new ContentStreamUpdateRequest(updatePath);
        req.addContentStream((ContentStream)contentStream);
        return solrClient.request((SolrRequest)req);
    }

    @VisibleForTesting
    public static String uptime(long uptimeMs) {
        if (uptimeMs <= 0L) {
            return "?";
        }
        long numDays = uptimeMs >= 86400000L ? uptimeMs / 86400000L : 0L;
        long rem = uptimeMs - numDays * 86400000L;
        long numHours = rem >= 3600000L ? rem / 3600000L : 0L;
        long numMinutes = (rem -= numHours * 3600000L) >= 60000L ? rem / 60000L : 0L;
        long numSeconds = Math.round((double)(rem -= numMinutes * 60000L) / 1000.0);
        return String.format(Locale.ROOT, "%d days, %d hours, %d minutes, %d seconds", numDays, numHours, numMinutes, numSeconds);
    }

    public static String normalizeSolrUrl(String solrUrl) {
        return SolrCLI.normalizeSolrUrl(solrUrl, true);
    }

    public static String normalizeSolrUrl(String solrUrl, boolean logUrlFormatWarning) {
        if (solrUrl != null) {
            if (solrUrl.contains("/solr")) {
                String newSolrUrl = solrUrl.substring(0, solrUrl.indexOf("/solr"));
                if (logUrlFormatWarning) {
                    CLIO.out("WARNING: URLs provided to this tool needn't include Solr's context-root (e.g. \"/solr\"). Such URLs are deprecated and support for them will be removed in a future release. Correcting from [" + solrUrl + "] to [" + newSolrUrl + "].");
                }
                solrUrl = newSolrUrl;
            }
            if (solrUrl.endsWith("/")) {
                solrUrl = solrUrl.substring(0, solrUrl.length() - 1);
            }
        }
        return solrUrl;
    }

    public static String resolveSolrUrl(CommandLine cli) throws Exception {
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            String zkHost = cli.getOptionValue("zkHost");
            if (zkHost == null) {
                solrUrl = SolrCLI.getDefaultSolrUrl();
                CLIO.getOutStream().println("Neither -zkHost or -solrUrl parameters provided so assuming solrUrl is " + solrUrl + ".");
            } else {
                try (CloudHttp2SolrClient cloudSolrClient = new CloudHttp2SolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();){
                    cloudSolrClient.connect();
                    Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
                    if (liveNodes.isEmpty()) {
                        throw new IllegalStateException("No live nodes found! Cannot determine 'solrUrl' from ZooKeeper: " + zkHost);
                    }
                    String firstLiveNode = (String)liveNodes.iterator().next();
                    solrUrl = ZkStateReader.from((CloudSolrClient)cloudSolrClient).getBaseUrlForNodeName(firstLiveNode);
                    solrUrl = SolrCLI.normalizeSolrUrl(solrUrl, false);
                }
            }
        }
        return solrUrl;
    }

    public static String getZkHost(CommandLine cli) throws Exception {
        String zkHost = cli.getOptionValue("zkHost");
        if (zkHost != null) {
            return zkHost;
        }
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            solrUrl = SolrCLI.getDefaultSolrUrl();
            CLIO.getOutStream().println("Neither -zkHost or -solrUrl parameters provided so assuming solrUrl is " + solrUrl + ".");
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            NamedList systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
            StatusTool statusTool = new StatusTool();
            Map<String, Object> status = statusTool.reportStatus((NamedList<Object>)systemInfo, solrClient);
            Map cloud = (Map)status.get("cloud");
            if (cloud != null) {
                String zookeeper = (String)cloud.get("ZooKeeper");
                if (zookeeper.endsWith("(embedded)")) {
                    zookeeper = zookeeper.substring(0, zookeeper.length() - "(embedded)".length());
                }
                zkHost = zookeeper;
            }
        }
        return zkHost;
    }

    public static boolean safeCheckCollectionExists(String solrUrl, String collection) {
        boolean exists = false;
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            NamedList existsCheckResult = solrClient.request((SolrRequest)new CollectionAdminRequest.List());
            List collections = (List)existsCheckResult.get("collections");
            exists = collections != null && collections.contains(collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static boolean safeCheckCoreExists(String solrUrl, String coreName) {
        boolean exists = false;
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            boolean wait = false;
            long startWaitAt = System.nanoTime();
            do {
                if (wait) {
                    int clamPeriodForStatusPollMs = 1000;
                    Thread.sleep(1000L);
                }
                NamedList existsCheckResult = CoreAdminRequest.getStatus((String)coreName, (SolrClient)solrClient).getResponse();
                NamedList status = (NamedList)existsCheckResult.get("status");
                NamedList coreStatus = (NamedList)status.get(coreName);
                Map failureStatus = (Map)existsCheckResult.get("initFailures");
                String errorMsg = (String)failureStatus.get(coreName);
                boolean hasName = coreStatus != null && coreStatus.asMap().containsKey("name");
                exists = hasName || errorMsg != null;
                boolean bl = wait = hasName && errorMsg == null && "true".equals(coreStatus.get("isLoading"));
            } while (wait && System.nanoTime() - startWaitAt < MAX_WAIT_FOR_CORE_LOAD_NANOS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static class AssertionFailureException
    extends Exception {
        public AssertionFailureException(String message) {
            super(message);
        }
    }
}

