/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.UserGroupApplicationService;
import de.justsoftware.people.application.model.PermissionDetails;
import de.justsoftware.people.application.model.ProfileSearchModel;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.UserGroupDetails;
import de.justsoftware.people.application.model.UserGroupDto;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.controller.UserGroupController;
import de.justsoftware.people.controller.model.PagedResultModel;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.model.UserGroupRole;
import de.justsoftware.permission.client.model.Role;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usergroups"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u000245B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0017J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0017J$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010 \u001a\u00020!H\u0017J@\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00192\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J6\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u00192\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001dH\u0017J>\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010'\u001a\u00020(H\u0017J4\u0010)\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001a\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010,\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0014\b\u0001\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.H\u0017J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u000f\u001a\u00020\u0010H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/people/controller/UserGroupController;", "", "userGroupApplicationService", "Lde/justsoftware/people/application/UserGroupApplicationService;", "searchApplicationService", "Lde/justsoftware/people/application/SearchApplicationService;", "<init>", "(Lde/justsoftware/people/application/UserGroupApplicationService;Lde/justsoftware/people/application/SearchApplicationService;)V", "createGroup", "Lde/justsoftware/people/application/model/UserGroupDetails;", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "userGroupNameModel", "Lde/justsoftware/people/controller/UserGroupController$UserGroupNameModel;", "getGroup", "groupId", "Lde/justsoftware/people/model/UserGroupId;", "getAllTenantUsersGroup", "Lde/justsoftware/people/application/model/UserGroupDto;", "mayInteract", "", "updateUserGroup", "", "deleteUserGroup", "getAllGroups", "Lde/justsoftware/people/model/PagedResult;", "query", "", "offset", "", "limit", "updateGroupMembers", "groupEditMembersModel", "Lde/justsoftware/people/controller/UserGroupController$GroupEditMembersModel;", "getUserGroupMembersForGroup", "Lde/justsoftware/people/business/profile/model/Profile;", "getUserGroupMembers", "filterUserGroupMembersForGroup", "Lde/justsoftware/people/controller/model/PagedResultModel;", "profileSearchModel", "Lde/justsoftware/people/application/model/ProfileSearchModel;", "filterUserGroupMembers", "getUserGroupPermissions", "Lde/justsoftware/people/application/model/PermissionDetails;", "updateUserGroupPermissions", "userGroupRoles", "", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/people/model/UserGroupRole;", "userGroupNotFound", "Ljava/util/function/Supplier;", "Lde/justsoftware/people/exceptions/NotFoundException;", "UserGroupNameModel", "GroupEditMembersModel", "people-api"})
public class UserGroupController {
    @NotNull
    private final UserGroupApplicationService userGroupApplicationService;
    @NotNull
    private final SearchApplicationService searchApplicationService;

    public UserGroupController(@NotNull UserGroupApplicationService userGroupApplicationService, @NotNull SearchApplicationService searchApplicationService) {
        Intrinsics.checkNotNullParameter((Object)userGroupApplicationService, (String)"userGroupApplicationService");
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        this.userGroupApplicationService = userGroupApplicationService;
        this.searchApplicationService = searchApplicationService;
    }

    @PostMapping
    @NotNull
    public UserGroupDetails createGroup(@NotNull AuthorizationContext authCtx, @RequestBody @NotNull UserGroupNameModel userGroupNameModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)userGroupNameModel, (String)"userGroupNameModel");
        UserGroupId userGroupId = this.userGroupApplicationService.createUserGroup(authCtx, userGroupNameModel.getName(), authCtx.getTenantId());
        Intrinsics.checkNotNullExpressionValue((Object)userGroupId, (String)"createUserGroup(...)");
        UserGroupId groupId = userGroupId;
        Object t = this.userGroupApplicationService.getUserGroupDetails(authCtx, groupId).orElseThrow(this.userGroupNotFound(groupId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (UserGroupDetails)t;
    }

    @GetMapping(value={"/{groupId}"})
    @NotNull
    public UserGroupDetails getGroup(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Object t = this.userGroupApplicationService.getUserGroupDetails(authCtx, groupId).orElseThrow(this.userGroupNotFound(groupId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (UserGroupDetails)t;
    }

    @GetMapping(value={"/allUsers"})
    @Nullable
    public UserGroupDto getAllTenantUsersGroup(@RequestParam(value="mayInteract", required=false, defaultValue="false") boolean mayInteract, @NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        return this.userGroupApplicationService.getAllTenantUsersGroup(authCtx, authCtx.getTenantId(), Boolean.valueOf(mayInteract)).orElse(null);
    }

    @PutMapping(value={"/{groupId}"})
    public void updateUserGroup(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId, @RequestBody @NotNull UserGroupNameModel userGroupNameModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)userGroupNameModel, (String)"userGroupNameModel");
        this.userGroupApplicationService.renameUserGroup(authCtx, groupId, userGroupNameModel.getName());
    }

    @DeleteMapping(value={"/{groupId}"})
    public void deleteUserGroup(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        this.userGroupApplicationService.deleteUserGroup(authCtx, groupId);
    }

    @Nonnull
    @GetMapping
    @NotNull
    public PagedResult<UserGroupDto> getAllGroups(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit, @NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        PagedResult pagedResult = this.userGroupApplicationService.getUserGroups(authCtx, authCtx.getTenantId(), Strings.nullToEmpty((String)query), offset, limit);
        Intrinsics.checkNotNullExpressionValue((Object)pagedResult, (String)"getUserGroups(...)");
        return pagedResult;
    }

    @PutMapping(value={"/{groupId}/members"})
    public void updateGroupMembers(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId, @RequestBody @NotNull GroupEditMembersModel groupEditMembersModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)groupEditMembersModel, (String)"groupEditMembersModel");
        this.userGroupApplicationService.updateMembers(authCtx, groupId, groupEditMembersModel.getAdd(), groupEditMembersModel.getRemove());
    }

    @GetMapping(value={"/{groupId}/members"})
    @NotNull
    public PagedResult<Profile> getUserGroupMembersForGroup(@NotNull AuthorizationContext authCtx, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit, @PathVariable @NotNull UserGroupId groupId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        String string = query;
        if (string == null) {
            string = "";
        }
        PagedResult pagedResult = PagedResults.map((PagedResult)this.searchApplicationService.allProfiles(authCtx, string, CollectionsKt.emptyList(), null, null, groupId, offset, limit), UserGroupController::getUserGroupMembersForGroup$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)pagedResult, (String)"map(...)");
        return pagedResult;
    }

    @GetMapping(value={"/members"})
    @NotNull
    public PagedResult<Profile> getUserGroupMembers(@NotNull AuthorizationContext authCtx, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        String string = query;
        if (string == null) {
            string = "";
        }
        PagedResult pagedResult = PagedResults.map((PagedResult)this.searchApplicationService.allProfiles(authCtx, string, CollectionsKt.emptyList(), null, null, null, offset, limit), UserGroupController::getUserGroupMembers$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)pagedResult, (String)"map(...)");
        return pagedResult;
    }

    @PostMapping(value={"/{groupId}/members"})
    @NotNull
    public PagedResultModel<Profile> filterUserGroupMembersForGroup(@NotNull AuthorizationContext authCtx, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit, @PathVariable @NotNull UserGroupId groupId, @RequestBody @NotNull ProfileSearchModel profileSearchModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)profileSearchModel, (String)"profileSearchModel");
        String string = profileSearchModel.getSearchString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchString(...)");
        ImmutableList immutableList = profileSearchModel.getSearchFilter();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getSearchFilter(...)");
        PagedResult result = this.searchApplicationService.allProfiles(authCtx, string, (List)immutableList, profileSearchModel.getFacetFilter(), null, groupId, offset, limit);
        return result.map(UserGroupController::filterUserGroupMembersForGroup$lambda$2).toPagedResultModel();
    }

    @PostMapping(value={"/members"})
    @NotNull
    public PagedResultModel<Profile> filterUserGroupMembers(@NotNull AuthorizationContext authCtx, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit, @RequestBody @NotNull ProfileSearchModel profileSearchModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileSearchModel, (String)"profileSearchModel");
        String string = profileSearchModel.getSearchString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchString(...)");
        ImmutableList immutableList = profileSearchModel.getSearchFilter();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getSearchFilter(...)");
        return this.searchApplicationService.allProfiles(authCtx, string, (List)immutableList, profileSearchModel.getFacetFilter(), null, null, offset, limit).map(UserGroupController::filterUserGroupMembers$lambda$3).toPagedResultModel();
    }

    @GetMapping(value={"/{groupId}/permissions"})
    @NotNull
    public PermissionDetails getUserGroupPermissions(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        PermissionDetails permissionDetails = this.userGroupApplicationService.getUserGroupPermissions(authCtx, groupId);
        Intrinsics.checkNotNullExpressionValue((Object)permissionDetails, (String)"getUserGroupPermissions(...)");
        return permissionDetails;
    }

    @PutMapping(value={"/{groupId}/permissions"})
    @NotNull
    public PermissionDetails updateUserGroupPermissions(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull UserGroupId groupId, @RequestBody @NotNull Map<Role, ? extends UserGroupRole> userGroupRoles) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(userGroupRoles, (String)"userGroupRoles");
        this.userGroupApplicationService.setUserGroupPermissions(authCtx, groupId, userGroupRoles);
        PermissionDetails permissionDetails = this.userGroupApplicationService.getUserGroupPermissions(authCtx, groupId);
        Intrinsics.checkNotNullExpressionValue((Object)permissionDetails, (String)"getUserGroupPermissions(...)");
        return permissionDetails;
    }

    private Supplier<NotFoundException> userGroupNotFound(UserGroupId groupId) {
        return () -> UserGroupController.userGroupNotFound$lambda$4(groupId);
    }

    private static final Profile getUserGroupMembersForGroup$lambda$0(ProfileSearchResult obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getProfile();
    }

    private static final Profile getUserGroupMembers$lambda$1(ProfileSearchResult obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getProfile();
    }

    private static final Profile filterUserGroupMembersForGroup$lambda$2(ProfileSearchResult obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getProfile();
    }

    private static final Profile filterUserGroupMembers$lambda$3(ProfileSearchResult obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getProfile();
    }

    private static final NotFoundException userGroupNotFound$lambda$4(UserGroupId $groupId) {
        return new NotFoundException("Could not find user group " + $groupId, $groupId.toString());
    }
}

