/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusCount;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusId;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH'J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H'J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH'JD\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH'J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH'J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\bH'J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0017J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH&J&\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011H'J.\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011H'J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH'J\u0016\u0010$\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\nH'J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H'J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\nH'J$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0013\u001a\u00020\u0014H'J*\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0,2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010-\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H'J \u0010.\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H'J&\u0010/\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011H'J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\"\u001a\u00020\bH'J6\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010\f\u001a\u00020\rH'J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u00104\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u0014H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00066\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatus;", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatusId;", "findWithNotifications", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatusWithNotification;", "receiverId", "", "types", "", "Lde/justsoftware/notificationclient/model/NotificationType;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findWithNotificationsUpdatedAfter", "", "since", "Ljava/time/Instant;", "findWithNotificationsBefore", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "timestamp", "findWithNotificationsBeforeByApp", "app", "findAllOpenAndUnmarked", "findAllOpenAndUnmarkedByApp", "setArchived", "", "notificationId", "Ljava/util/UUID;", "updatedAt", "deleteByReceiverId", "notificationIds", "archiveAllByTarget", "targetId", "distinctReceivers", "disableMailTriggers", "countByReceiverIdAndStatus", "countUpdatesForReceiverSinceTimestamp", "getStatusWithActiveTriggerForReceivers", "receiverIds", "countByReceiverIdsAndStatus", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatusCount;", "countByReceiverIdsAndStatusAsMap", "", "mark", "unmark", "setOpen", "findIdByTargetId", "findByReceiverIdAndStatusAndMarkedAndShouldTriggerMail", "marked", "", "shouldTriggerMail", "findAllByShouldTriggerMailAndStatusOrderByReceiverId", "notification-service"})
@SourceDebugExtension(value={"SMAP\nDeliveryStatusRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeliveryStatusRepository.kt\nde/justsoftware/notificationservice/persistence/DeliveryStatusRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1222#2,2:334\n1252#2,4:336\n*S KotlinDebug\n*F\n+ 1 DeliveryStatusRepository.kt\nde/justsoftware/notificationservice/persistence/DeliveryStatusRepository\n*L\n262#1:334,2\n262#1:336,4\n*E\n"})
public interface DeliveryStatusRepository
extends JpaRepository<DbDeliveryStatus, DbDeliveryStatusId> {
    @Query(value="\n        SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification(deliveryStatus, notification)\n        FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId AND notification.type IN :types\n        ")
    @NotNull
    public Page<DbDeliveryStatusWithNotification> findWithNotifications(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull Pageable var3);

    @Query(value="\n        SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification(deliveryStatus, notification)\n        FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId\n        AND deliveryStatus.updatedAt > :since\n        AND notification.type IN :types\n        ")
    @NotNull
    public List<DbDeliveryStatusWithNotification> findWithNotificationsUpdatedAfter(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull Instant var3);

    @Query(value="\n        SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification(deliveryStatus, notification)\n        FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId\n        AND deliveryStatus.status = :status\n        AND notification.type IN :types\n        AND notification.timestamp < :timestamp\n        ")
    @NotNull
    public Page<DbDeliveryStatusWithNotification> findWithNotificationsBefore(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull NotificationStatus var3, @NotNull Instant var4, @NotNull Pageable var5);

    @Query(value="\n        SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification(deliveryStatus, notification)\n        FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId\n        AND deliveryStatus.status = :status\n        AND notification.type IN :types\n        AND notification.appId = :app\n        AND notification.timestamp < :timestamp\n        ")
    @NotNull
    public Page<DbDeliveryStatusWithNotification> findWithNotificationsBeforeByApp(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull NotificationStatus var3, @NotNull String var4, @NotNull Instant var5, @NotNull Pageable var6);

    @Query(value="\n        SELECT deliveryStatus FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId\n        AND deliveryStatus.status = 'OPEN'\n        AND notification.type IN :types\n        AND deliveryStatus.marked = false\n        ")
    @NotNull
    public List<DbDeliveryStatus> findAllOpenAndUnmarked(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2);

    @Query(value="\n        SELECT deliveryStatus FROM DbDeliveryStatus deliveryStatus\n        INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id\n        WHERE deliveryStatus.receiverId = :receiverId\n        AND deliveryStatus.status = 'OPEN'\n        AND notification.type IN :types\n        AND notification.appId = :app\n        AND deliveryStatus.marked = false\n        ")
    @NotNull
    public List<DbDeliveryStatus> findAllOpenAndUnmarkedByApp(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull String var3);

    @Modifying
    @Transactional
    default public int setArchived(@NotNull String receiverId, @NotNull UUID notificationId, @NotNull Instant updatedAt) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        return this.setArchived((Iterable)SetsKt.setOf((Object)notificationId), receiverId, updatedAt);
    }

    public int deleteByReceiverId(@NotNull String var1);

    @Modifying
    @Query(value="\n        UPDATE DbDeliveryStatus d\n        SET d.status = 'ARCHIVED', d.shouldTriggerMail = false, d.marked = false, d.updatedAt = :updatedAt\n        WHERE d.notificationId IN :notificationIds\n        AND d.receiverId = :receiverId\n        ")
    @Transactional
    public int setArchived(@NotNull Iterable<UUID> var1, @NotNull String var2, @NotNull Instant var3);

    @Modifying
    @Query(value="\n        UPDATE DbDeliveryStatus d\n        SET d.status = 'ARCHIVED', d.shouldTriggerMail = false, d.marked = false, d.updatedAt = :updatedAt\n        WHERE d.receiverId = :receiverId\n        AND d.status = 'OPEN'\n        AND d.marked = false\n        AND d.notificationId IN (\n            SELECT n.id FROM DbNotification n\n            WHERE n.id = d.notificationId\n            AND n.type IN :types\n            AND n.targetId = :targetId\n        )\n        ")
    @Transactional
    public int archiveAllByTarget(@NotNull String var1, @NotNull Iterable<? extends NotificationType> var2, @NotNull String var3, @NotNull Instant var4);

    @Query(value="SELECT DISTINCT d.receiverId FROM DbDeliveryStatus d WHERE d.shouldTriggerMail = true")
    @NotNull
    public List<String> distinctReceivers();

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.shouldTriggerMail = false WHERE d IN :status")
    @Transactional
    public int disableMailTriggers(@NotNull Iterable<? extends DbDeliveryStatus> var1);

    public int countByReceiverIdAndStatus(@NotNull String var1, @NotNull NotificationStatus var2);

    @Query(value="\n        SELECT count(ds.notificationId)\n        FROM DbDeliveryStatus ds\n        WHERE ds.updatedAt > :since AND ds.receiverId = :receiverId")
    public int countUpdatesForReceiverSinceTimestamp(@NotNull String var1, @NotNull Instant var2);

    @Query(value="\n        SELECT d\n        FROM DbDeliveryStatus d\n        WHERE d.receiverId IN :receiverIds AND d.shouldTriggerMail = true ORDER BY d.receiverId\n        ")
    @NotNull
    public List<DbDeliveryStatus> getStatusWithActiveTriggerForReceivers(@NotNull Iterable<String> var1);

    @Query(value="\n        SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusCount(ds.receiverId, count(ds))\n        FROM DbDeliveryStatus ds\n        WHERE ds.receiverId IN :receiverIds AND ds.status = :status\n        GROUP BY ds.receiverId\n        ")
    @NotNull
    public List<DbDeliveryStatusCount> countByReceiverIdsAndStatus(@NotNull Iterable<String> var1, @NotNull NotificationStatus var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, Integer> countByReceiverIdsAndStatusAsMap(@NotNull Iterable<String> receiverIds, @NotNull NotificationStatus status) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Iterable $this$associateBy$iv = this.countByReceiverIdsAndStatus(receiverIds, status);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DbDeliveryStatusCount dbDeliveryStatusCount = (DbDeliveryStatusCount)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            DbDeliveryStatusCount p0 = (DbDeliveryStatusCount)element$iv$iv;
            String string = p0.getReceiverId();
            boolean bl2 = false;
            Integer n = Math.toIntExact(it.getCount());
            map.put(string, n);
        }
        return destination$iv$iv;
    }

    @Modifying
    @Query(value="\n        UPDATE DbDeliveryStatus d\n        SET d.status = 'OPEN', d.marked = true, d.updatedAt = :updatedAt\n        WHERE d.notificationId = :notificationId AND d.receiverId = :receiverId\n        ")
    @Transactional
    public int mark(@NotNull String var1, @NotNull UUID var2, @NotNull Instant var3);

    @Modifying
    @Query(value="\n        UPDATE DbDeliveryStatus d\n        SET d.marked = false, d.updatedAt = :updatedAt\n        WHERE d.notificationId = :notificationId AND d.receiverId = :receiverId\n        ")
    @Transactional
    public int unmark(@NotNull String var1, @NotNull UUID var2, @NotNull Instant var3);

    @Modifying
    @Query(value="\n        UPDATE DbDeliveryStatus d\n        SET d.status = 'OPEN', d.updatedAt = :updatedAt\n        WHERE d.notificationId IN :notificationIds\n        AND d.receiverId = :receiverId\n        AND d.status = 'ARCHIVED'\n        ")
    @Transactional
    public int setOpen(@NotNull Iterable<UUID> var1, @NotNull String var2, @NotNull Instant var3);

    @Query(value="\n        SELECT d.id\n        FROM DbDeliveryStatus d\n        INNER JOIN DbNotification n ON d.notificationId = n.id\n        WHERE n.targetId = :targetId\n        ")
    @NotNull
    public List<DbDeliveryStatusId> findIdByTargetId(@NotNull String var1);

    @Transactional
    @VisibleForTesting
    @Deprecated(message="only to be used for testing")
    @NotNull
    public Page<DbDeliveryStatus> findByReceiverIdAndStatusAndMarkedAndShouldTriggerMail(@NotNull String var1, @NotNull NotificationStatus var2, boolean var3, boolean var4, @NotNull Pageable var5);

    @VisibleForTesting
    @Deprecated(message="only to be used for testing")
    @NotNull
    public List<DbDeliveryStatus> findAllByShouldTriggerMailAndStatusOrderByReceiverId(boolean var1, @NotNull NotificationStatus var2);
}

