/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.mobile.model.MobileChangeList;
import de.justsoftware.notificationservice.mobile.model.MobileSyncToken;
import de.justsoftware.notificationservice.mobile.service.MobileChangesService;
import de.justsoftware.notificationservice.mobile.service.MobileSyncService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobileSyncService;", "", "changesService", "Lde/justsoftware/notificationservice/mobile/service/MobileChangesService;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobileChangesService;Ljava/time/Clock;)V", "getChanges", "Lde/justsoftware/notificationservice/mobile/model/MobileChangeList;", "syncToken", "Lde/justsoftware/notificationservice/mobile/model/MobileSyncToken;", "authContext", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "Companion", "notification-service"})
public class MobileSyncService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobileChangesService changesService;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Duration CHANGES_MAX_AGE;

    public MobileSyncService(@NotNull MobileChangesService changesService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)changesService, (String)"changesService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.changesService = changesService;
        this.clock = clock;
    }

    @NotNull
    public MobileChangeList getChanges(@Nullable MobileSyncToken syncToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Instant now = this.clock.instant();
        Intrinsics.checkNotNull((Object)now);
        Companion.access$checkForDeprecatedSyncToken((Companion)Companion, (MobileSyncToken)syncToken, (Instant)now);
        Companion.access$validateTenant((Companion)Companion, (MobileSyncToken)syncToken, (AuthorizationContext)authContext);
        List changes = this.changesService.getChanges(MobileSyncToken.Companion.toChangeQuery(syncToken), authContext.getProfileId(), authContext.getLocale());
        return new MobileChangeList(changes, new MobileSyncToken(0, now, authContext.getTenantId(), 1, null));
    }

    public static final /* synthetic */ Duration access$getCHANGES_MAX_AGE$cp() {
        return CHANGES_MAX_AGE;
    }

    static {
        Duration duration = Duration.ofDays(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        CHANGES_MAX_AGE = duration;
    }
}

