/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.mobile.model.ChangeQuery;
import de.justsoftware.notificationservice.mobile.model.MobileChange;
import de.justsoftware.notificationservice.mobile.model.MobileNotification;
import de.justsoftware.notificationservice.mobile.model.MobileNotificationsCount;
import de.justsoftware.notificationservice.mobile.service.MobileChangesService;
import de.justsoftware.notificationservice.mobile.service.MobileNotificationService;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobileChangesService;", "", "mobileNotificationService", "Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;", "notificationService", "Lde/justsoftware/notificationservice/business/NotificationService;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;Lde/justsoftware/notificationservice/business/NotificationService;)V", "getChanges", "", "Lde/justsoftware/notificationservice/mobile/model/MobileChange;", "query", "Lde/justsoftware/notificationservice/mobile/model/ChangeQuery;", "profileId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "locale", "Ljava/util/Locale;", "fullChanges", "incrementalChanges", "since", "Ljava/time/Instant;", "notificationsCountChange", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobileChangesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileChangesService.kt\nde/justsoftware/notificationservice/mobile/service/MobileChangesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1563#2:78\n1634#2,3:79\n1563#2:82\n1634#2,3:83\n1563#2:86\n1634#2,3:87\n*S KotlinDebug\n*F\n+ 1 MobileChangesService.kt\nde/justsoftware/notificationservice/mobile/service/MobileChangesService\n*L\n51#1:78\n51#1:79,3\n60#1:82\n60#1:83,3\n63#1:86\n63#1:87,3\n*E\n"})
public class MobileChangesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobileNotificationService mobileNotificationService;
    @NotNull
    private final NotificationService notificationService;
    public static final int FULL_SYNC_MAX_NOTIFICATIONS = 100;

    public MobileChangesService(@NotNull MobileNotificationService mobileNotificationService, @NotNull NotificationService notificationService) {
        Intrinsics.checkNotNullParameter((Object)mobileNotificationService, (String)"mobileNotificationService");
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        this.mobileNotificationService = mobileNotificationService;
        this.notificationService = notificationService;
    }

    @NotNull
    public List<MobileChange> getChanges(@NotNull ChangeQuery query, @NotNull ProfileId profileId, @NotNull Locale locale) {
        List list;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ChangeQuery changeQuery = query;
        if (changeQuery instanceof ChangeQuery.All) {
            list = this.fullChanges(profileId, locale);
        } else if (changeQuery instanceof ChangeQuery.Changed) {
            list = this.incrementalChanges(profileId, locale, ((ChangeQuery.Changed)query).getSince());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List notificationChanges = list;
        return CollectionsKt.plus((Collection)notificationChanges, (Object)this.notificationsCountChange(profileId));
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> fullChanges(ProfileId profileId, Locale locale) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.mobileNotificationService.getMobileNotifications(profileId, 100, locale);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void notification;
            MobileNotification mobileNotification = (MobileNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileNotification)notification));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> incrementalChanges(ProfileId profileId, Locale locale, Instant since) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable iterable = this.mobileNotificationService.getUpdatedMobileNotifications(profileId, since, locale);
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MobileNotification mobileNotification = (MobileNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileNotification)it));
        }
        List updatedNotifications = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.mobileNotificationService.getDeletedMobileNotificationIds(profileId, since);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID bl = (UUID)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(MobileChange.Companion.toDeleteNotificationChange(string));
        }
        List deletedNotifications = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)updatedNotifications, (Iterable)deletedNotifications);
    }

    private MobileChange notificationsCountChange(ProfileId profileId) {
        return (MobileChange)MobileChange.Companion.toUpdateChange(MobileNotificationsCount.Companion.toMobileNotificationsCount(this.notificationService.getNotificationsCount(profileId)));
    }
}

