/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.translation;

import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.OriginalLanguageRepository;
import de.justsoftware.wikiservice.persistence.TranslationRepository;
import de.justsoftware.wikiservice.persistence.model.DbOriginalLanguage;
import de.justsoftware.wikiservice.persistence.model.DbTranslation;
import de.justsoftware.wikiservice.translation.DeepLTranslationProvider;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationProvider;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.annotation.TranslatableField;
import de.justsoftware.wikiservice.translation.handler.TranslationHandler;
import de.justsoftware.wikiservice.translation.model.TranslatableText;
import de.justsoftware.wikiservice.translation.model.TranslationContext;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationException;
import de.justsoftware.wikiservice.translation.model.TranslationMetaData;
import de.justsoftware.wikiservice.translation.model.TranslationResult;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.ReflectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 52\u00020\u0001:\u00015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\f\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J>\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0011\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0011\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0011\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 H\u0011\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0012J\u0016\u0010\"\u001a\u00020\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&H\u0012J2\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0(0\u0015\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\r0)H\u0012J<\u0010*\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012JF\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J8\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110,H\u0012J\u0016\u00102\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020-0\u0015H\u0012J\u001e\u00104\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020-0\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/wikiservice/translation/TranslationService;", "", "translationProvider", "Lde/justsoftware/wikiservice/translation/TranslationProvider;", "translationRepository", "Lde/justsoftware/wikiservice/persistence/TranslationRepository;", "originalLanguageRepository", "Lde/justsoftware/wikiservice/persistence/OriginalLanguageRepository;", "transactionManager", "Lorg/springframework/transaction/PlatformTransactionManager;", "<init>", "(Lde/justsoftware/wikiservice/translation/TranslationProvider;Lde/justsoftware/wikiservice/persistence/TranslationRepository;Lde/justsoftware/wikiservice/persistence/OriginalLanguageRepository;Lorg/springframework/transaction/PlatformTransactionManager;)V", "translate", "T", "Lde/justsoftware/wikiservice/translation/Translatable;", "model", "targetLanguage", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "(Lde/justsoftware/wikiservice/translation/Translatable;Ljava/lang/String;Lde/justsoftware/wikiservice/model/TenantId;)Lde/justsoftware/wikiservice/translation/Translatable;", "", "models", "handleArticleVersionDeleted", "", "evt", "Lde/justsoftware/wikiservice/model/ArticleDeletedEvent;", "handleArticleVersionDeleted$wiki_service", "handleChapterModified", "Lde/justsoftware/wikiservice/model/ChapterModifiedEvent;", "handleChapterModified$wiki_service", "handleWikiModified", "Lde/justsoftware/wikiservice/model/WikiModifiedEvent;", "handleWikiModified$wiki_service", "deleteTranslations", "id", "Lde/justsoftware/wikiservice/model/ItemId;", "ids", "", "getTranslatableText", "Lde/justsoftware/wikiservice/translation/TranslationService$Companion$TranslatableTextResult;", "", "doTranslate", "getTranslation", "", "Lde/justsoftware/wikiservice/translation/model/TranslationResult;", "text", "Lde/justsoftware/wikiservice/translation/model/TranslatableText;", "sourceLanguages", "getTranslationFromDB", "saveDetectedOriginalLanguageIntoDB", "translationResults", "saveTranslationIntoDB", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTranslationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationService.kt\nde/justsoftware/wikiservice/translation/TranslationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1863#2,2:404\n1557#2:406\n1628#2,3:407\n1863#2,2:410\n1628#2,3:413\n1557#2:416\n1628#2,2:417\n1863#2,2:419\n1630#2:421\n1202#2,2:422\n1230#2,4:424\n1557#2:428\n1628#2,3:429\n1187#2,2:432\n1261#2,4:434\n774#2:445\n865#2,2:446\n1557#2:448\n1628#2,3:449\n1557#2:452\n1628#2,2:453\n1630#2:457\n1202#2,2:458\n1230#2,4:460\n1557#2:464\n1628#2,3:465\n1202#2,2:468\n1230#2,4:470\n774#2:474\n865#2,2:475\n1557#2:477\n1628#2,3:478\n774#2:481\n865#2,2:482\n1202#2,2:484\n1230#2,4:486\n1557#2:490\n1628#2,3:491\n1202#2,2:494\n1230#2,4:496\n1202#2,2:500\n1230#2,4:502\n1485#2:506\n1510#2,3:507\n1513#2,3:517\n1246#2,2:522\n1187#2,2:524\n1261#2,4:526\n1249#2:530\n1557#2:542\n1628#2,3:543\n1611#2,9:546\n1863#2:555\n1864#2:557\n1620#2:558\n1628#2,3:560\n1557#2:563\n1628#2,3:564\n7#3:412\n7#3:559\n535#4:438\n520#4,6:439\n381#4,7:510\n462#4:520\n412#4:521\n535#4:531\n520#4,6:532\n216#5,2:455\n126#5:538\n153#5,3:539\n1#6:556\n*S KotlinDebug\n*F\n+ 1 TranslationService.kt\nde/justsoftware/wikiservice/translation/TranslationService\n*L\n64#1:404,2\n75#1:406\n75#1:407,3\n78#1:410,2\n93#1:413,3\n128#1:416\n128#1:417,2\n134#1:419,2\n128#1:421\n173#1:422,2\n173#1:424,4\n175#1:428\n175#1:429,3\n176#1:432,2\n176#1:434,4\n190#1:445\n190#1:446,2\n193#1:448\n193#1:449,3\n199#1:452\n199#1:453,2\n199#1:457\n223#1:458,2\n223#1:460,4\n226#1:464\n226#1:465,3\n247#1:468,2\n247#1:470,4\n254#1:474\n254#1:475,2\n262#1:477\n262#1:478,3\n278#1:481\n278#1:482,2\n282#1:484,2\n282#1:486,4\n284#1:490\n284#1:491,3\n299#1:494,2\n299#1:496,4\n307#1:500,2\n307#1:502,4\n311#1:506\n311#1:507,3\n311#1:517,3\n312#1:522,2\n312#1:524,2\n312#1:526,4\n312#1:530\n331#1:542\n331#1:543,3\n336#1:546,9\n336#1:555\n336#1:557\n336#1:558\n353#1:560,3\n367#1:563\n367#1:564,3\n93#1:412\n353#1:559\n178#1:438\n178#1:439,6\n311#1:510,7\n312#1:520\n312#1:521\n313#1:531\n313#1:532,6\n212#1:455,2\n320#1:538\n320#1:539,3\n336#1:556\n*E\n"})
public class TranslationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationProvider translationProvider;
    @NotNull
    private final TranslationRepository translationRepository;
    @NotNull
    private final OriginalLanguageRepository originalLanguageRepository;
    @NotNull
    private final PlatformTransactionManager transactionManager;
    private static final Logger LOG = LoggerFactory.getLogger(TranslationService.class);

    public TranslationService(@NotNull TranslationProvider translationProvider, @NotNull TranslationRepository translationRepository, @NotNull OriginalLanguageRepository originalLanguageRepository, @NotNull PlatformTransactionManager transactionManager) {
        Intrinsics.checkNotNullParameter((Object)translationProvider, (String)"translationProvider");
        Intrinsics.checkNotNullParameter((Object)translationRepository, (String)"translationRepository");
        Intrinsics.checkNotNullParameter((Object)originalLanguageRepository, (String)"originalLanguageRepository");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        this.translationProvider = translationProvider;
        this.translationRepository = translationRepository;
        this.originalLanguageRepository = originalLanguageRepository;
        this.transactionManager = transactionManager;
    }

    @NotNull
    public <T extends Translatable<? extends T>> T translate(@NotNull T model, @Nullable String targetLanguage, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (T)((Translatable)CollectionsKt.first((List)this.translate(CollectionsKt.listOf(model), targetLanguage, tenantId)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Translatable<? extends T>> List<T> translate(@NotNull List<? extends T> models, @Nullable String targetLanguage, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(models, (String)"models");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (targetLanguage == null) {
            return models;
        }
        try {
            return this.doTranslate(models, targetLanguage, tenantId);
        }
        catch (TranslationException e) {
            Iterable $this$forEach$iv = models;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Translatable it = (Translatable)element$iv;
                boolean bl = false;
                it.setTranslationMetaData(new TranslationMetaData(targetLanguage, null, null, e.getErrorCode(), 6, null));
            }
            return models;
        }
        catch (Throwable e) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$forEach$iv = models;
            String string = "Failed to translate models with IDs {}. Returning the original instance.";
            Logger logger = LOG;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Translatable translatable = (Translatable)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.translationId());
            }
            collection = (List)destination$iv$iv;
            logger.error(string, (Object)collection, (Object)e);
            $this$forEach$iv = models;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Translatable it = (Translatable)element$iv;
                boolean bl = false;
                it.setTranslationMetaData(new TranslationMetaData(targetLanguage, null, null, TranslationErrorCode.UNKNOWN_ERROR, 6, null));
            }
            return models;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener
    @Transactional
    public void handleArticleVersionDeleted$wiki_service(@NotNull ArticleDeletedEvent evt) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable iterable = evt.getArticleVersionIds();
        TranslationService translationService = this;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArticleVersionId articleVersionId = (ArticleVersionId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        translationService.deleteTranslations((Set)destination$iv$iv);
    }

    @Async
    @EventListener
    @Transactional
    public void handleChapterModified$wiki_service(@NotNull ChapterModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.deleteTranslations((ItemId)evt.getId());
    }

    @Async
    @EventListener
    @Transactional
    public void handleArticleVersionDeleted$wiki_service(@NotNull ChapterModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.deleteTranslations((ItemId)evt.getId());
    }

    @Async
    @EventListener
    @Transactional
    public void handleWikiModified$wiki_service(@NotNull WikiModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.deleteTranslations((ItemId)evt.getId());
    }

    private void deleteTranslations(ItemId id) {
        this.deleteTranslations(SetsKt.setOf((Object)id.toString()));
    }

    private void deleteTranslations(Set<String> ids) {
        LOG.info("Deleting translations in the database for item IDs: {}", ids);
        this.originalLanguageRepository.deleteAllById((Iterable)ids);
        this.translationRepository.deleteByItemIdIn(ids);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Translatable<? extends T>> List<Companion.TranslatableTextResult<T>> getTranslatableText(Collection<? extends T> models) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = models;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void model;
            Translatable translatable = (Translatable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String translationItemId = model.translationId();
            LinkedHashMap translatable2 = new LinkedHashMap();
            LinkedHashMap propToHandler = new LinkedHashMap();
            Iterable $this$forEach$iv = Companion.access$getTranslatableFieldProps((Companion)Companion, (Object)model);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                KProperty1 prop = (KProperty1)pair.component1();
                TranslatableField translatableAnnotation = (TranslatableField)pair.component2();
                KCallablesJvm.setAccessible((KCallable)((KCallable)prop), (boolean)true);
                Object[] objectArray = new Object[]{model};
                Object raw = prop.getGetter().call(objectArray);
                Object object = KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass((Class)translatableAnnotation.handler()));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.wikiservice.translation.handler.TranslationHandler<kotlin.Any?>");
                TranslationHandler handler = (TranslationHandler)object;
                TranslationContext ctx = new TranslationContext((Object)model, translationItemId, model.getClass(), prop.getName(), translatableAnnotation.value());
                handler.init(raw, ctx);
                Map translatableData = handler.getTranslatableData();
                if (!(!translatableData.isEmpty())) continue;
                translatable2.putAll(translatableData);
                ((Map)propToHandler).put(prop, handler);
            }
            collection.add(new Companion.TranslatableTextResult(translationItemId, (Object)model, new TranslatableText(translationItemId, translatable2), (Map)propToHandler));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Translatable<? extends T>> List<T> doTranslate(List<? extends T> models, String targetLanguage, TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object element$iv$iv;
        Map $this$associateTo$iv$iv;
        void $this$associate$iv;
        Collection collection;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        Object object;
        Object element$iv$iv22;
        void $this$associateByTo$iv$iv2;
        if (!this.translationProvider.isTranslationEnabled(tenantId)) {
            return models;
        }
        String string = DeepLTranslationProvider.Companion.standardizeLanguageCode(targetLanguage);
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        String standardizeTargetLanguage = string;
        Iterable $this$associateBy$iv2 = models;
        boolean $i$f$associateBy22 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv2;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv22 : $this$associateByTo$iv$iv2) {
            void it;
            Translatable translatable = (Translatable)element$iv$iv22;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.translationId(), element$iv$iv22);
        }
        Map originalModels = destination$iv$iv;
        Iterable capacity$iv22 = models;
        object = this.originalLanguageRepository;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            Translatable bl = (Translatable)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.translationId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $i$f$associateBy22 = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv4 = $this$associate$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        element$iv$iv22 = $this$associateTo$iv$iv.iterator();
        while (element$iv$iv22.hasNext()) {
            element$iv$iv = element$iv$iv22.next();
            Object it = destination$iv$iv2;
            DbOriginalLanguage it2 = (DbOriginalLanguage)element$iv$iv;
            boolean bl = false;
            it2 = TuplesKt.to((Object)it2.getItemId(), (Object)it2.getLanguage());
            it.put(it2.getFirst(), it2.getSecond());
        }
        Object sourceLanguages = destination$iv$iv2;
        Map $this$filter$iv = originalModels;
        boolean $i$f$filter = false;
        $this$associateTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        element$iv$iv22 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv22.hasNext()) {
            boolean bl;
            Object it = element$iv$iv = (Map.Entry)element$iv$iv22.next();
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)standardizeTargetLanguage, sourceLanguages.get(it.getKey()))) {
                LOG.debug("Target language '" + standardizeTargetLanguage + "' is the original language of " + it.getKey() + ". Nothing to translate.");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object modelsToTranslate = destination$iv$iv2;
        Iterable $this$filter$iv2 = this.getTranslatableText(modelsToTranslate.values());
        boolean $i$f$filter22 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            Companion.TranslatableTextResult it = (Companion.TranslatableTextResult)element$iv$iv3;
            boolean bl = false;
            boolean bl4 = !((Map)it.getTranslatedText().getText()).isEmpty();
            if (!bl4) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List translatableTextResults = (List)destination$iv$iv3;
        Iterable $i$f$filter22 = translatableTextResults;
        object = this;
        boolean $i$f$map2 = false;
        destination$iv$iv3 = $this$map$iv;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            Companion.TranslatableTextResult bl = (Companion.TranslatableTextResult)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl5 = false;
            collection.add(it.getTranslatedText());
        }
        Map translationResults = super.getTranslation((List)destination$iv$iv4, standardizeTargetLanguage, (Map)sourceLanguages, tenantId);
        Iterable $this$map$iv3 = translatableTextResults;
        boolean $i$f$map3 = false;
        destination$iv$iv4 = $this$map$iv3;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Translatable translatable;
            void it;
            Companion.TranslatableTextResult bl5 = (Companion.TranslatableTextResult)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            TranslationResult translationResult = (TranslationResult)translationResults.get(it.getId());
            if (translationResult == null) {
                LOG.error("Illegal State, no TranslationResult found for " + it.getId() + ". Return UNKNOWN_ERROR.");
                ((Translatable)it.getModel()).setTranslationMetaData(new TranslationMetaData(targetLanguage, null, null, TranslationErrorCode.UNKNOWN_ERROR));
                translatable = (Translatable)it.getModel();
            } else {
                Translatable result = ((Translatable)it.getModel()).shallowCopy();
                Map $this$forEach$iv = it.getPropsToHandler();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl6 = false;
                    KProperty prop = (KProperty)entry.getKey();
                    TranslationHandler handler = (TranslationHandler)entry.getValue();
                    Object translatedValue = handler.getTranslation(translationResult.getTranslatedText());
                    ReflectionUtilsKt.setField((Object)result, (KProperty)prop, (Object)translatedValue);
                }
                result.setTranslationMetaData(new TranslationMetaData(standardizeTargetLanguage, translationResult.getDetectedSourceLanguage(), it.getModel(), null, 8, null));
                translatable = result;
            }
            object.add(translatable);
        }
        $this$map$iv3 = (List)destination$iv$iv5;
        boolean $i$f$associateBy = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv5 = $this$associateBy$iv;
        Map destination$iv$iv6 = new LinkedHashMap(capacity$iv32);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv4 : $this$associateByTo$iv$iv) {
            void it;
            Translatable bl = (Translatable)element$iv$iv4;
            object = destination$iv$iv6;
            boolean bl7 = false;
            object.put(it.translationId(), element$iv$iv4);
        }
        Map translatedModels = destination$iv$iv6;
        $this$map$iv3 = models;
        $i$f$map3 = false;
        Iterable capacity$iv32 = $this$map$iv3;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo = false;
        for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Translatable element$iv$iv4 = (Translatable)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            Translatable translatable = (Translatable)translatedModels.get(it.translationId());
            if (translatable == null) {
                translatable = it;
            }
            object.add(translatable);
        }
        return (List)destination$iv$iv5;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, TranslationResult> getTranslation(List<TranslatableText> text, String targetLanguage, Map<String, String> sourceLanguages, TenantId tenantId) throws TranslationException {
        void $this$mapTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterTo$iv$iv2;
        Object it;
        Object object2;
        Iterable $this$associateByTo$iv$iv2;
        void $this$associateBy$iv;
        if (text.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable iterable = this.getTranslationFromDB(text, targetLanguage, sourceLanguages);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_10 = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            TranslationResult translationResult = (TranslationResult)element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.put(it.getTranslationId(), element$iv$iv);
        }
        Map translationFromDB = destination$iv$iv;
        if (LOG.isDebugEnabled() && !translationFromDB.isEmpty()) {
            LOG.debug("Translations for '" + targetLanguage + "' of items " + translationFromDB.keySet() + " found in DB.");
        }
        Iterable $this$filter$iv = text;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (TranslatableText)element$iv$iv;
            boolean bl = false;
            if (!(!translationFromDB.containsKey(it.getTranslationId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingTranslations = (List)destination$iv$iv;
        if (missingTranslations.isEmpty()) {
            return translationFromDB;
        }
        $this$filter$iv = missingTranslations;
        String string = targetLanguage;
        String string2 = "Translations for '{}' of items {} not in DB. They will be translated now.";
        object2 = LOG;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (TranslatableText)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getTranslationId());
        }
        object = (List)destination$iv$iv;
        object2.debug(string2, (Object)string, object);
        List translationResults = this.translationProvider.translate(missingTranslations, null, targetLanguage, tenantId);
        this.saveDetectedOriginalLanguageIntoDB(translationResults);
        Iterable $this$filter$iv2 = translationResults;
        boolean $i$f$filter2 = false;
        Iterable $i$f$mapTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TranslationResult result = (TranslationResult)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)result.getDetectedSourceLanguage(), (Object)targetLanguage))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List usedTranslationFromTranslationProvider = (List)destination$iv$iv2;
        this.saveTranslationIntoDB(usedTranslationFromTranslationProvider, targetLanguage);
        Iterable $this$associateBy$iv2 = usedTranslationFromTranslationProvider;
        boolean $i$f$associateBy2 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable $i$f$filterTo22 = $this$associateBy$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            TranslationResult translationResult = (TranslationResult)element$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object2.put(it2.getTranslationId(), element$iv$iv);
        }
        Map translationFromProvider = destination$iv$iv3;
        Iterable $this$map$iv2 = text;
        boolean $i$f$map2 = false;
        Iterable capacity$iv22 = $this$map$iv2;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            TranslatableText element$iv$iv = (TranslatableText)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl = false;
            TranslationResult translationResult = (TranslationResult)translationFromDB.get(it3.getTranslationId());
            if (translationResult == null && (translationResult = (TranslationResult)translationFromProvider.get(it3.getTranslationId())) == null) {
                translationResult = new TranslationResult(it3.getTranslationId(), (Map)it3.getText(), targetLanguage);
            }
            object2.add(translationResult);
        }
        $this$map$iv2 = (List)destination$iv$iv4;
        $i$f$associateBy2 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv4 = $this$associateBy$iv2;
        destination$iv$iv = new LinkedHashMap(capacity$iv3);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it4;
            TranslationResult bl = (TranslationResult)element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            object2.put(it4.getTranslationId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<TranslationResult> getTranslationFromDB(List<TranslatableText> text, String targetLanguage, Map<String, String> sourceLanguages) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map translation;
        Map.Entry entry;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Object value$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = text;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TranslatableText translatableText = (TranslatableText)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getTranslationId(), element$iv$iv);
        }
        Map textById = destination$iv$iv;
        $this$associateBy$iv = this.translationRepository.findByLanguageAndItemIdIn(targetLanguage, textById.keySet());
        boolean $i$f$groupBy = false;
        void capacity$iv22 = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            DbTranslation it = (DbTranslation)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getItemId();
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            List dbTranslation = (List)value$iv$iv$iv.getValue();
            Iterable $this$associate$iv = dbTranslation;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv3;
                DbTranslation it = (DbTranslation)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)it.getFieldId(), (Object)it.getText());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv3;
            object.put(k, map);
        }
        $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            boolean bl;
            entry = element$iv$iv;
            boolean bl5 = false;
            String itemId = (String)entry.getKey();
            translation = (Map)entry.getValue();
            Object object3 = (TranslatableText)textById.get(itemId);
            if (object3 != null && (object3 = object3.getText()) != null && (object3 = ((LinkedHashMap)object3).keySet()) != null) {
                Object fieldIds = object3;
                boolean bl6 = false;
                bl = translation.keySet().containsAll((Collection)fieldIds);
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            entry = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl = false;
            String itemId = (String)entry.getKey();
            translation = (Map)entry.getValue();
            object.add(new TranslationResult(itemId, translation, sourceLanguages.get(itemId)));
        }
        return (List)destination$iv$iv2;
    }

    private void saveDetectedOriginalLanguageIntoDB(List<TranslationResult> translationResults) {
        new TransactionTemplate(this.transactionManager).execute(arg_0 -> TranslationService.saveDetectedOriginalLanguageIntoDB$lambda$33(translationResults, this, arg_0));
    }

    private void saveTranslationIntoDB(List<TranslationResult> translationResults, String targetLanguage) {
        new TransactionTemplate(this.transactionManager).execute(arg_0 -> TranslationService.saveTranslationIntoDB$lambda$36(translationResults, targetLanguage, this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final List saveDetectedOriginalLanguageIntoDB$lambda$33(List $translationResults, TranslationService this$0, TransactionStatus it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $translationResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            object = (TranslationResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getTranslationId());
        }
        List ids = (List)destination$iv$iv;
        LOG.debug("Save detected original language for items {} into the DB.", (Object)ids);
        this$0.originalLanguageRepository.deleteAllById((Iterable)ids);
        this$0.originalLanguageRepository.flush();
        $this$map$iv = $translationResults;
        collection = this$0.originalLanguageRepository;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            DbOriginalLanguage dbOriginalLanguage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            TranslationResult result = (TranslationResult)element$iv$iv;
            boolean bl2 = false;
            if (DeepLTranslationProvider.Companion.standardizeLanguageCode(result.getDetectedSourceLanguage()) != null) {
                String it3;
                boolean bl3 = false;
                dbOriginalLanguage = new DbOriginalLanguage(result.getTranslationId(), it3);
            } else {
                dbOriginalLanguage = null;
            }
            if (dbOriginalLanguage == null) continue;
            DbOriginalLanguage it$iv$iv = dbOriginalLanguage;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return collection.saveAll((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final List saveTranslationIntoDB$lambda$36(List $translationResults, String $targetLanguage, TranslationService this$0, TransactionStatus it) {
        void $this$map$iv;
        TranslationResult it2;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = $translationResults;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TranslationResult translationResult = (TranslationResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getTranslationId());
        }
        Set ids = (Set)destination$iv$iv;
        LOG.debug("Save translations for target language '{}' for items {} into DB.", (Object)$targetLanguage, (Object)ids);
        this$0.translationRepository.deleteByLanguageAndItemIdIn($targetLanguage, ids);
        this$0.translationRepository.flush();
        $this$mapToSet$iv = $translationResults;
        collection = this$0.translationRepository;
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (TranslationResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(Companion.toDBTranslations$wiki_service(it2, $targetLanguage));
        }
        return collection.saveAll(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }
}

