/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.prosemirror;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.wikiservice.prosemirror.error.MissingAttributeException;
import de.justsoftware.wikiservice.prosemirror.error.MissingValueException;
import de.justsoftware.wikiservice.prosemirror.error.UnknownNodeException;
import de.justsoftware.wikiservice.prosemirror.model.marks.BackgroundColor;
import de.justsoftware.wikiservice.prosemirror.model.marks.Code;
import de.justsoftware.wikiservice.prosemirror.model.marks.Em;
import de.justsoftware.wikiservice.prosemirror.model.marks.Link;
import de.justsoftware.wikiservice.prosemirror.model.marks.Mark;
import de.justsoftware.wikiservice.prosemirror.model.marks.StrikeThrough;
import de.justsoftware.wikiservice.prosemirror.model.marks.Strong;
import de.justsoftware.wikiservice.prosemirror.model.marks.TextColor;
import de.justsoftware.wikiservice.prosemirror.model.marks.Underline;
import de.justsoftware.wikiservice.prosemirror.model.nodes.BlockQuote;
import de.justsoftware.wikiservice.prosemirror.model.nodes.BulletList;
import de.justsoftware.wikiservice.prosemirror.model.nodes.CodeBlock;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Doc;
import de.justsoftware.wikiservice.prosemirror.model.nodes.DriveDocument;
import de.justsoftware.wikiservice.prosemirror.model.nodes.HardBreak;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Heading;
import de.justsoftware.wikiservice.prosemirror.model.nodes.HorizontalRule;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Image;
import de.justsoftware.wikiservice.prosemirror.model.nodes.InfoBox;
import de.justsoftware.wikiservice.prosemirror.model.nodes.InternalLink;
import de.justsoftware.wikiservice.prosemirror.model.nodes.ListItem;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Node;
import de.justsoftware.wikiservice.prosemirror.model.nodes.OrderedList;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Paragraph;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Person;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Table;
import de.justsoftware.wikiservice.prosemirror.model.nodes.TableCell;
import de.justsoftware.wikiservice.prosemirror.model.nodes.TableHeader;
import de.justsoftware.wikiservice.prosemirror.model.nodes.TableRow;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Text;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Video;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Vimeo;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Youtube;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u001a*\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u0005\u001a0\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u001e\u0010\u0011\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u0005\u001a&\u0010\u0012\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convertJSONStringToPMNode", "Lde/justsoftware/wikiservice/prosemirror/model/nodes/Node;", "jsonString", "", "jsonToNode", "json", "", "", "jsonToMark", "Lde/justsoftware/wikiservice/prosemirror/model/marks/Mark;", "getMap", "value", "getList", "", "param", "getValue", "getAttr", "nodeName", "attr", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProsemirrorExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProsemirrorExporter.kt\nde/justsoftware/wikiservice/prosemirror/ProsemirrorExporterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1557#2:138\n1628#2,3:139\n1557#2:142\n1628#2,3:143\n*S KotlinDebug\n*F\n+ 1 ProsemirrorExporter.kt\nde/justsoftware/wikiservice/prosemirror/ProsemirrorExporterKt\n*L\n59#1:138\n59#1:139,3\n63#1:142\n63#1:143,3\n*E\n"})
public final class ProsemirrorExporterKt {
    @NotNull
    private static final ObjectMapper mapper;

    @NotNull
    public static final Node convertJSONStringToPMNode(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Object object = mapper.readValue(jsonString, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map json = (Map)object;
        return ProsemirrorExporterKt.jsonToNode((Map)json);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Node jsonToNode(@NotNull Map<String, ? extends Object> json) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Object object = ProsemirrorExporterKt.getValue(json, (String)"type");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String type = (String)object;
        Map attrs = ProsemirrorExporterKt.getMap(json, (String)"attrs");
        Iterable $this$map$iv = ProsemirrorExporterKt.getList(json, (String)"marks");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Map map = (Map)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ProsemirrorExporterKt.jsonToMark((Map)it));
        }
        List marks = (List)destination$iv$iv;
        String string = (String)json.get("text");
        if (string == null) {
            string = "";
        }
        String text = string;
        List content = ProsemirrorExporterKt.getList(json, (String)"content");
        Iterable $this$map$iv2 = content;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map map = (Map)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ProsemirrorExporterKt.jsonToNode((Map)it));
        }
        List pmContent = (List)destination$iv$iv2;
        return switch (type) {
            case "blockquote" -> (Node)new BlockQuote(pmContent);
            case "bullet_list" -> (Node)new BulletList(pmContent);
            case "code_block" -> (Node)new CodeBlock(pmContent);
            case "doc" -> (Node)new Doc(pmContent);
            case "hard_break" -> (Node)new HardBreak();
            case "heading" -> (Node)Heading.Companion.fromJSON(attrs, pmContent);
            case "horizontal_rule" -> (Node)new HorizontalRule();
            case "image" -> (Node)Image.Companion.fromJSON(attrs);
            case "document" -> (Node)DriveDocument.Companion.fromJSON(attrs);
            case "infobox" -> (Node)new InfoBox(pmContent);
            case "internalLink" -> (Node)InternalLink.Companion.fromJSON(attrs);
            case "list_item" -> (Node)new ListItem(pmContent);
            case "ordered_list" -> (Node)new OrderedList(pmContent);
            case "paragraph" -> (Node)new Paragraph(pmContent);
            case "person" -> (Node)Person.Companion.fromJSON(attrs);
            case "table" -> (Node)new Table(pmContent);
            case "table_header" -> (Node)new TableHeader(pmContent);
            case "table_cell" -> (Node)new TableCell(pmContent);
            case "table_row" -> (Node)new TableRow(pmContent);
            case "text" -> (Node)new Text(text, marks);
            case "video" -> (Node)Video.Companion.fromJSON(attrs);
            case "vimeoVideo" -> (Node)Vimeo.Companion.fromJSON(attrs);
            case "youtubeVideo" -> (Node)Youtube.Companion.fromJSON(attrs);
            default -> throw new UnknownNodeException(type);
        };
    }

    @NotNull
    public static final Mark jsonToMark(@NotNull Map<String, ? extends Object> json) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Object object = ProsemirrorExporterKt.getValue(json, (String)"type");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String type = (String)object;
        Map attrs = ProsemirrorExporterKt.getMap(json, (String)"attrs");
        return switch (type) {
            case "strong" -> (Mark)new Strong();
            case "em" -> (Mark)new Em();
            case "underline" -> (Mark)new Underline();
            case "strikethrough" -> (Mark)new StrikeThrough();
            case "backgroundColor" -> (Mark)new BackgroundColor(BackgroundColor.Companion.colorFromAttrs(attrs));
            case "textColor" -> (Mark)new TextColor(TextColor.Companion.colorFromAttrs(attrs));
            case "link" -> (Mark)Link.Companion.fromJSON(attrs);
            case "code" -> (Mark)new Code();
            default -> throw new UnknownNodeException(type);
        };
    }

    @NotNull
    public static final Map<String, Object> getMap(@NotNull Map<String, ? extends Object> $this$getMap, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$getMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = $this$getMap.get(value);
        if (object == null) {
            return MapsKt.emptyMap();
        }
        Object map = object;
        if (!(map instanceof Map)) {
            throw new MissingValueException(value, $this$getMap);
        }
        return (Map)map;
    }

    @NotNull
    public static final List<Map<String, Object>> getList(@NotNull Map<String, ? extends Object> $this$getList, @NotNull String param) {
        Intrinsics.checkNotNullParameter($this$getList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Object object = $this$getList.get(param);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object content = object;
        if (!(content instanceof List)) {
            throw new MissingValueException(param, $this$getList);
        }
        return (List)content;
    }

    @NotNull
    public static final Object getValue(@NotNull Map<String, ? extends Object> $this$getValue, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$getValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = $this$getValue.get(value);
        if (object == null) {
            throw new MissingValueException(value, $this$getValue);
        }
        return object;
    }

    @NotNull
    public static final Object getAttr(@NotNull Map<String, ? extends Object> $this$getAttr, @NotNull String nodeName, @NotNull String attr) {
        Intrinsics.checkNotNullParameter($this$getAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Object object = $this$getAttr.get(attr);
        if (object == null) {
            throw new MissingAttributeException(nodeName, attr, $this$getAttr);
        }
        return object;
    }

    static {
        ObjectMapper objectMapper;
        ObjectMapper $this$mapper_u24lambda_u240 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$mapper_u24lambda_u240.registerModule((Module)new KotlinModule.Builder().build());
        mapper = objectMapper;
    }
}

