/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.wikiservice.business.exceptions.NoGranteeException;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.business.exceptions.NotFoundException;
import de.justsoftware.wikiservice.config.ExceptionHandlerConfiguration;
import de.justsoftware.wikiservice.exception.BadRequestException;
import de.justsoftware.wikiservice.exception.UnauthorizedException;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.orm.jpa.JpaObjectRetrievalFailureException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.async.AsyncRequestNotUsableException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0010\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "Lde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration$ErrorResponse;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "handleBadRequestException", "Lde/justsoftware/wikiservice/exception/BadRequestException;", "handleNotFoundException", "handleNotAllowedException", "Lde/justsoftware/wikiservice/business/exceptions/NotAllowedException;", "handleBadRequestExceptions", "handleUnauthorizedException", "Lde/justsoftware/wikiservice/exception/UnauthorizedException;", "ErrorResponse", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration\n+ 2 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,105:1\n8#2:106\n7#2,3:107\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration\n*L\n101#1:106\n101#1:107,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public ErrorResponse handleAllExceptions(@NotNull Exception e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!(e instanceof AsyncRequestNotUsableException)) {
            LOG.error(DEFAULT_ERROR, (Throwable)e);
        }
        response.setContentType("application/json");
        return new ErrorResponse(DEFAULT_ERROR);
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ErrorResponse handleBadRequestException(@NotNull BadRequestException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={NotFoundException.class, JpaObjectRetrievalFailureException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @NotNull
    public ErrorResponse handleNotFoundException(@NotNull Exception e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={NotAllowedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    @NotNull
    public ErrorResponse handleNotAllowedException(@NotNull NotAllowedException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class, IllegalArgumentException.class, NoGranteeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ErrorResponse handleBadRequestExceptions(@NotNull Exception e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @NotNull
    public ErrorResponse handleUnauthorizedException(@NotNull UnauthorizedException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/json");
        return new ErrorResponse(e.getMessage());
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

