/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.assistant.kafka;

import de.justsoftware.wikiservice.ai.assistant.business.AiAssistantService;
import de.justsoftware.wikiservice.ai.assistant.kafka.KafkaTenantAiSettingsConsumer;
import de.justsoftware.wikiservice.kafka.model.KafkaTenant;
import de.justsoftware.wikiservice.kafka.model.LlmSettings;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.openaiofficial.OpenAiOfficialStreamingChatModel;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0017J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer;", "", "<init>", "()V", "streamingChatModels", "Ljava/util/HashMap;", "Lde/justsoftware/wikiservice/model/TenantId;", "Ldev/langchain4j/model/chat/StreamingChatModel;", "Lkotlin/collections/HashMap;", "onTenantChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/wikiservice/kafka/model/KafkaTenant;", "getStreamingChatModel", "tenantId", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nKafkaTenantAiSettingsConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaTenantAiSettingsConsumer.kt\nde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1863#2,2:62\n*S KotlinDebug\n*F\n+ 1 KafkaTenantAiSettingsConsumer.kt\nde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer\n*L\n28#1:62,2\n*E\n"})
public class KafkaTenantAiSettingsConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<TenantId, StreamingChatModel> streamingChatModels = new HashMap();
    @NotNull
    public static final String TOPIC = "just.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(AiAssistantService.class);

    @KafkaListener(id="tenantsAiAssistantConsumer", containerFactory="tenantsAiAssistantConsumerFactory", topics={"just.tenants"}, idIsGroup=false)
    public void onTenantChanged(@NotNull ConsumerRecords<TenantId, KafkaTenant> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            Object object2 = this;
            try {
                Object object3;
                LlmSettings llmSettings;
                KafkaTenantAiSettingsConsumer $this$onTenantChanged_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                KafkaTenant kafkaTenant = (KafkaTenant)record.value();
                Object object4 = llmSettings = kafkaTenant != null ? kafkaTenant.getLlmSettings() : null;
                if (llmSettings != null) {
                    ((Map)$this$onTenantChanged_u24lambda_u242_u24lambda_u240.streamingChatModels).put(record.key(), OpenAiOfficialStreamingChatModel.builder().baseUrl(llmSettings.getUrl()).apiKey(llmSettings.getApiKey()).modelName(llmSettings.getModel()).build());
                    object3 = Unit.INSTANCE;
                } else {
                    object3 = $this$onTenantChanged_u24lambda_u242_u24lambda_u240.streamingChatModels.remove(record.key());
                }
                object = Result.constructor-impl(object3);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object error = object = throwable;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{record.key(), record.offset(), error};
            LOG.error("Unable to update AI Assistant Model for TenantId {} at offset {}.", objectArray);
        }
    }

    @Nullable
    public StreamingChatModel getStreamingChatModel(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (StreamingChatModel)this.streamingChatModels.get(tenantId);
    }
}

