/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.TableOfContentsDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.TableOfContentsElement;
import de.justsoftware.wikiservice.business.model.UpdateTableOfContentsElement;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;", "", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "maxChapterDepth", "", "<init>", "(Lde/justsoftware/wikiservice/business/TableOfContentsService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/translation/TranslationService;I)V", "read", "Lde/justsoftware/wikiservice/application/model/TableOfContentsDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "translationLanguage", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "update", "updatedItems", "", "Lde/justsoftware/wikiservice/business/model/UpdateTableOfContentsElement;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTableOfContentsApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableOfContentsApplicationService.kt\nde/justsoftware/wikiservice/application/TableOfContentsApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n1557#3:101\n1628#3,3:102\n*S KotlinDebug\n*F\n+ 1 TableOfContentsApplicationService.kt\nde/justsoftware/wikiservice/application/TableOfContentsApplicationService\n*L\n64#1:101\n64#1:102,3\n*E\n"})
public class TableOfContentsApplicationService {
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final TranslationService translationService;
    private final int maxChapterDepth;

    public TableOfContentsApplicationService(@NotNull TableOfContentsService tableOfContentsService, @NotNull WikiService wikiService, @NotNull AuthorizationService authorizationService, @NotNull TranslationService translationService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        this.tableOfContentsService = tableOfContentsService;
        this.wikiService = wikiService;
        this.authorizationService = authorizationService;
        this.translationService = translationService;
        this.maxChapterDepth = maxChapterDepth;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TableOfContentsDto read(@NotNull WikiId wikiId, @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        TranslationMetaData translationMetaData;
        TranslationMetaData errorCode;
        List sortedTOCElements;
        boolean mayWriteWiki;
        Wiki wiki;
        block7: {
            Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
            Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
            authContext.checkReadWiki(wikiId);
            wiki = (Wiki)this.translationService.translate((Translatable)this.wikiService.read(wikiId), translationLanguage, authContext.getTenantId());
            mayWriteWiki = this.authorizationService.mayWriteWikis(SetsKt.setOf((Object)wikiId), authContext.getUser()).getOrDefault(wikiId, false);
            sortedTOCElements = this.tableOfContentsService.getSortedTOCElements((ParentId)wikiId, wikiId, translationLanguage, authContext);
            TranslationMetaData translationMetaData2 = wiki.getTranslationMetaData();
            if (translationMetaData2 == null || (translationMetaData2 = translationMetaData2.getErrorCode()) == null) {
                for (Object it : (Iterable)sortedTOCElements) {
                    boolean bl = false;
                    TranslationMetaData translationMetaData3 = it.getTranslationMetaData();
                    it = translationMetaData3 != null ? translationMetaData3.getErrorCode() : null;
                    if (it == null) continue;
                    translationMetaData2 = it;
                    break block7;
                }
                translationMetaData2 = errorCode = null;
            }
        }
        if (translationLanguage != null) {
            Collection<TranslationMetaData> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            TranslationMetaData translationMetaData4 = wiki.getTranslationMetaData();
            if (translationMetaData4 == null || (translationMetaData4 = (Wiki)translationMetaData4.getSourceData()) == null) {
                translationMetaData4 = wiki;
            }
            TranslationMetaData originalWiki = translationMetaData4;
            TranslationMetaData translationMetaData5 = wiki.getTranslationMetaData();
            String string = translationMetaData5 != null ? translationMetaData5.getSourceLanguage() : null;
            it = sortedTOCElements;
            int n = this.maxChapterDepth;
            boolean bl = mayWriteWiki;
            String string2 = originalWiki.getTitle();
            WikiId wikiId2 = wikiId;
            boolean $i$f$map = false;
            void var14_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                TableOfContentsElement tableOfContentsElement = (TableOfContentsElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                TranslationMetaData translationMetaData6 = element.getTranslationMetaData();
                if (translationMetaData6 == null || (translationMetaData6 = (TableOfContentsElement)translationMetaData6.getSourceData()) == null) {
                    translationMetaData6 = element;
                }
                collection.add(translationMetaData6);
            }
            collection = (List)destination$iv$iv;
            TranslationMetaData translationMetaData7 = null;
            Collection<TranslationMetaData> collection2 = collection;
            int n2 = n;
            boolean bl3 = bl;
            String string3 = string2;
            WikiId wikiId3 = wikiId2;
            TableOfContentsDto tableOfContentsDto = new TableOfContentsDto(wikiId3, string3, bl3, n2, collection2, translationMetaData7);
            translationMetaData = new TranslationMetaData(translationLanguage, string, (Object)tableOfContentsDto, (TranslationErrorCode)errorCode);
        } else {
            translationMetaData = null;
        }
        TranslationMetaData translationMetaData8 = translationMetaData;
        return new TableOfContentsDto(wikiId, wiki.getTitle(), mayWriteWiki, this.maxChapterDepth, sortedTOCElements, translationMetaData8);
    }

    @NotNull
    public TableOfContentsDto update(@NotNull WikiId wikiId, @NotNull List<UpdateTableOfContentsElement> updatedItems, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(updatedItems, (String)"updatedItems");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(wikiId);
        this.tableOfContentsService.update(wikiId, updatedItems, authContext.getUser(), this.maxChapterDepth);
        return this.read(wikiId, null, authContext);
    }
}

