/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.spring;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"de.justsoftware.onx"})
@ParametersAreNonnullByDefault
public class JustConnectDefaultHandlerExceptionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(JustConnectDefaultHandlerExceptionResolver.class);

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Object> handleException(Exception e) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        LOG.error("An exception occured in a controller in de.justsoftware.onx", (Throwable)e);
        return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Object> handleError(Error e) throws Exception {
        LOG.error("An error occured in a controller in de.justsoftware.onx", (Throwable)e);
        throw e;
    }
}

