/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.events.PersonAuthenticatedEvent;
import de.justsoftware.onx.security.SecurityUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UpdateLastLoginEventHandler {
    @Autowired
    private JCEventBus _eventBus;

    @EventListener
    public void onAuthenticationSuccess(InteractiveAuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        PersonId personId = SecurityUtils.getUserIdOrNull((Authentication)authentication);
        if (personId != null) {
            this._eventBus.post((ServerEvent)new PersonAuthenticatedEvent(personId));
        }
    }
}

