/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.controller.PeopleController;
import de.justsoftware.publicAPI.controller.model.ProfileDto;
import de.justsoftware.publicAPI.exception.MissingScopeException;
import de.justsoftware.publicAPI.generated.apis.ProfileControllerApi;
import de.justsoftware.publicAPI.model.ProfileId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;

@RestController
@RequestMapping(value={"/v1/people"})
@Tag(name="Just People", description="Public API for Just People contents")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/publicAPI/controller/PeopleController;", "", "peopleBaseUrl", "", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/http/client/ClientHttpRequestInitializer;Lorg/springframework/web/client/RestClient$Builder;)V", "profileControllerApi", "Lde/justsoftware/publicAPI/generated/apis/ProfileControllerApi;", "getProfile", "Lde/justsoftware/publicAPI/controller/model/ProfileDto;", "profileId", "Lde/justsoftware/publicAPI/model/ProfileId;", "authContext", "Lde/justsoftware/publicAPI/authorization/ProfileAuthContext;", "Companion", "public-api-service"})
public class PeopleController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileControllerApi profileControllerApi;
    @NotNull
    public static final String USER_PEOPLE_READ_PERMISSION = "user:people.read";

    public PeopleController(@Value(value="${just.people.api.baseUrl}") @NotNull String peopleBaseUrl, @Qualifier(value="commonRequestInitializer") @NotNull ClientHttpRequestInitializer commonRequestInitializer, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)peopleBaseUrl, (String)"peopleBaseUrl");
        Intrinsics.checkNotNullParameter((Object)commonRequestInitializer, (String)"commonRequestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        RestClient restClient = restClientBuilder.requestInitializer(commonRequestInitializer).baseUrl(peopleBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.profileControllerApi = new ProfileControllerApi(restClient);
    }

    @Operation(summary="Fetch a profile by id", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:people.read")
    @GetMapping(value={"/profile/{profileId}"})
    @NotNull
    public ProfileDto getProfile(@PathVariable @Parameter(name="profileId", description="Id of the profile to fetch in the form of \"PROFILE,$INTEGER\".", example="PROFILE,1") @NotNull ProfileId profileId, @NotNull ProfileAuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.hasScope(USER_PEOPLE_READ_PERMISSION)) {
            throw new MissingScopeException();
        }
        return ProfileDto.Companion.toProfileDto(this.profileControllerApi.getProfile(profileId.toString()));
    }
}

