/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.config.ExceptionHandlerConfiguration;
import de.justsoftware.publicAPI.config.NewsGraphQLClient;
import de.justsoftware.publicAPI.controller.NewsController;
import de.justsoftware.publicAPI.controller.model.NewsPostExportDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/news"})
@Tag(name="Just News", description="Public API for the Just News app")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/publicAPI/controller/NewsController;", "", "newsGraphQLClient", "Lde/justsoftware/publicAPI/config/NewsGraphQLClient;", "<init>", "(Lde/justsoftware/publicAPI/config/NewsGraphQLClient;)V", "getNewsPosts", "", "Lde/justsoftware/publicAPI/controller/model/NewsPostExportDto;", "channelId", "", "offset", "", "limit", "request", "Ljakarta/servlet/http/HttpServletRequest;", "authContext", "Lde/justsoftware/publicAPI/authorization/ProfileAuthContext;", "Companion", "public-api-service"})
public class NewsController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NewsGraphQLClient newsGraphQLClient;
    public static final long MAX_EXPORT_LIMIT = 50L;
    @NotNull
    public static final String USER_NEWS_READ_PERMISSION = "user:news.read";

    public NewsController(@NotNull NewsGraphQLClient newsGraphQLClient) {
        Intrinsics.checkNotNullParameter((Object)newsGraphQLClient, (String)"newsGraphQLClient");
        this.newsGraphQLClient = newsGraphQLClient;
    }

    @Operation(summary="Returns a list of all news posts in a given channel", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:news.read")
    @ApiResponses(value={@ApiResponse(description="Successfully exported news posts", responseCode="200"), @ApiResponse(description="Request validation error: one or more inputs are invalid", responseCode="400", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExceptionHandlerConfiguration.ValidationErrors.class))})})
    @GetMapping(value={"/channels/{id}/posts"})
    @NotNull
    public List<NewsPostExportDto> getNewsPosts(@Parameter(name="id", description="The id of the channel of the posts to fetch", required=true, example="CHANNEL,xh3leisih7v6") @PathVariable(value="id") @NotNull String channelId, @Parameter(name="offset", description="Skip first n (offset) news posts to export.", required=false) @Min(value=0L, message="Offset must be a non-negative integer") @RequestParam(value="offset", required=false, defaultValue="0") int offset, @Parameter(name="limit", description="Maximum number of simultaneously exported news posts.", required=false) @Min(value=1L, message="Limit must be a positive integer less or equal to 50") @Max(value=50L, message="Limit must be a positive integer less or equal to 50") @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull HttpServletRequest request2, @NotNull ProfileAuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    public static final /* synthetic */ NewsGraphQLClient access$getNewsGraphQLClient$p(NewsController $this) {
        return $this.newsGraphQLClient;
    }
}

