/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence;

import com.google.common.collect.Iterators;
import de.justsoftware.permission.persistence.SqlResultBuilder;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SqlBuilder
extends SqlResultBuilder {
    @Nonnull
    public SqlBuilder append(String var1, Object ... var2);

    @Nonnull
    default public SqlBuilder appendParam(Object param) {
        return this.append(" ? ", new Object[]{param});
    }

    @Nonnull
    default public <T> SqlBuilder appendParams(String separator, Iterator<? extends T> objects, BiFunction<SqlBuilder, T, SqlBuilder> perEntryOperation) {
        if (!objects.hasNext()) {
            return this;
        }
        SqlBuilder sb = perEntryOperation.apply(this, (SqlBuilder)objects.next());
        while (objects.hasNext()) {
            sb = perEntryOperation.apply(sb.append(separator, new Object[0]), (SqlBuilder)objects.next());
        }
        return sb;
    }

    @Nonnull
    default public <T> SqlBuilder appendParams(String separator, Iterable<? extends T> objects, BiFunction<SqlBuilder, T, SqlBuilder> perEntryOperation) {
        return this.appendParams(separator, objects.iterator(), perEntryOperation);
    }

    @Nonnull
    default public SqlBuilder appendParams(String separator, Iterator<?> params) {
        return this.appendParams(separator, params, SqlBuilder::appendParam);
    }

    @Nonnull
    default public SqlBuilder appendParams(String separator, Stream<?> params) {
        return this.appendParams(separator, params.iterator(), SqlBuilder::appendParam);
    }

    @Nonnull
    default public SqlBuilder appendParams(String separator, Iterable<?> params) {
        return this.appendParams(separator, params.iterator());
    }

    @Nonnull
    default public SqlBuilder appendParams(String separator, Object ... params) {
        return this.appendParams(separator, (Iterator)Iterators.forArray((Object[])params));
    }
}

