/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.role.model;

import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.role.model.ItemRoleWithoutType;
import de.justsoftware.permission.business.role.model.ProfileIdentityRole;
import de.justsoftware.permission.business.role.model.ProfileRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.business.role.model.StaticRole;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public interface Role {
    public static final char ITEM_ROLE_SEPARATOR = '@';
    public static final char WILDCARD = '*';
    public static final String WILDCARD_STRING = "*";

    @Nonnull
    public String name();

    public void accept(Visitor var1);

    default public boolean isUserGroupRole() {
        return false;
    }

    default public boolean isProfileRole() {
        return false;
    }

    default public boolean isItemRoleWithId() {
        return false;
    }

    @Nonnull
    public static Role valueOf(String name) {
        String typeOrId;
        String trimmedName = StringUtils.trimToNull((String)name);
        int itemRoleSeparatorIndex = Role.getItemRoleSeparatorIndex((String)trimmedName);
        if (itemRoleSeparatorIndex < 0) {
            if (trimmedName.startsWith("PROFILE,")) {
                return new ProfileRole(trimmedName);
            }
            return StaticRole.create((String)trimmedName);
        }
        Optional identityRole = ProfileIdentityRole.parse((String)trimmedName);
        if (identityRole.isPresent()) {
            return (Role)identityRole.get();
        }
        ItemRoleWithoutType role = ItemRoleWithoutType.get((String)trimmedName.substring(0, itemRoleSeparatorIndex));
        switch (typeOrId = trimmedName.substring(itemRoleSeparatorIndex + 1)) {
            case "": {
                throw new IllegalArgumentException("@ must be followed by an item type, an item id or a star");
            }
            case "*": {
                return role;
            }
        }
        int comma = typeOrId.indexOf(44);
        switch (comma) {
            case 0: {
                throw new IllegalArgumentException("@ directly followed by , is not allowed in " + trimmedName);
            }
            case -1: {
                throw new UnsupportedOperationException("item actions not yet implemented");
            }
        }
        ItemId itemId = ItemId.valueOf((String)typeOrId);
        if (itemId.getPlainId().equals("*")) {
            return role.withItemType(itemId.getType());
        }
        return role.withItem(itemId);
    }

    public static int getItemRoleSeparatorIndex(String trimmedName) {
        if (trimmedName == null) {
            throw new IllegalArgumentException("empty string supplied for nonnull method");
        }
        int at = trimmedName.indexOf(64);
        if (at == 0) {
            throw new IllegalArgumentException("no role name before @ found in " + trimmedName);
        }
        return at;
    }
}

