/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.role.model;

import com.google.common.base.Preconditions;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.role.model.AbstractRole;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.ItemRoleWithType;
import de.justsoftware.permission.business.role.model.ItemRoleWithoutType;
import de.justsoftware.permission.business.role.model.PathResolvableRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.business.role.model.TenantManagerRole;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ItemRoleWithId
extends AbstractRole
implements DirectlyResolvableRole {
    private final ItemRoleWithType _itemRoleWithType;
    private final ItemId _itemId;

    ItemRoleWithId(ItemRoleWithType itemRoleWithType, ItemId itemId) {
        super(itemRoleWithType.withoutType().getPathResolvableName() + "@" + itemId.asString());
        Preconditions.checkArgument((boolean)itemRoleWithType.getItemType().equals((Object)itemId.getType()));
        this._itemRoleWithType = itemRoleWithType;
        this._itemId = itemId;
    }

    @Nonnull
    public static ItemRoleWithId create(ItemRoleWithType itemRoleWithType, ItemId itemId) {
        if (TenantManagerRole.isTenantManagerRole((ItemRoleWithoutType)itemRoleWithType.withoutType(), (ItemId)itemId)) {
            return new TenantManagerRole(itemId);
        }
        return new ItemRoleWithId(itemRoleWithType, itemId);
    }

    public void accept(Role.Visitor visitor) {
        visitor.visitItemRoleWithId(this);
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    @Nonnull
    public ItemRoleWithType withoutId() {
        return this._itemRoleWithType;
    }

    @Nonnull
    public PathResolvableRole withoutType() {
        return this._itemRoleWithType.withoutType();
    }

    public boolean isItemRoleWithId() {
        return true;
    }
}

