/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.commentNotifications;

import de.justsoftware.news.domain.commentNotifications.CommentNotifications;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsCrud;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsReceivers;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;", "", "<init>", "()V", "crud", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsCrud;", "create", "Lde/justsoftware/news/domain/commentNotifications/CommentNotifications;", "profileId", "Lde/justsoftware/news/id/ProfileId;", "postId", "Lde/justsoftware/news/id/PostId;", "enabled", "", "upsert", "findAllByProfileIdAndPostIdIn", "", "postIds", "", "getProfileIds", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsReceivers;", "news-service"})
@SourceDebugExtension(value={"SMAP\nCommentNotificationsRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentNotificationsRepo.kt\nde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1285#3,2:104\n1299#3,4:106\n3307#3,10:110\n1563#3:120\n1634#3,3:121\n1563#3:124\n1634#3,3:125\n*S KotlinDebug\n*F\n+ 1 CommentNotificationsRepo.kt\nde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo\n*L\n52#1:104,2\n52#1:106,4\n58#1:110,10\n61#1:120\n61#1:121,3\n62#1:124\n62#1:125,3\n*E\n"})
public class CommentNotificationsRepo {
    @Autowired
    private CommentNotificationsCrud crud;

    @NotNull
    public CommentNotifications create(@NotNull ProfileId profileId, @NotNull PostId postId, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        CommentNotificationsCrud commentNotificationsCrud = this.crud;
        if (commentNotificationsCrud == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
            commentNotificationsCrud = null;
        }
        commentNotificationsCrud.insert(profileId, postId, enabled);
        CommentNotificationsCrud commentNotificationsCrud2 = this.crud;
        if (commentNotificationsCrud2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
            commentNotificationsCrud2 = null;
        }
        return commentNotificationsCrud2.getByProfileIdAndPostId(profileId, postId);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CommentNotifications upsert(@NotNull ProfileId profileId, @NotNull PostId postId, boolean enabled) {
        CommentNotifications commentNotifications;
        CommentNotifications commentNotifications2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        CommentNotificationsCrud commentNotificationsCrud = this.crud;
        if (commentNotificationsCrud == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
            commentNotificationsCrud = null;
        }
        if ((commentNotifications2 = commentNotificationsCrud.findByProfileIdAndPostId(profileId, postId)) != null) {
            CommentNotifications origin = commentNotifications2;
            boolean bl = false;
            CommentNotificationsCrud commentNotificationsCrud2 = this.crud;
            if (commentNotificationsCrud2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
                commentNotificationsCrud2 = null;
            }
            CommentNotifications commentNotifications3 = (CommentNotifications)commentNotificationsCrud2.save((Object)CommentNotifications.copy$default((CommentNotifications)origin, (long)0L, null, null, (boolean)enabled, (int)7, null));
            if (commentNotifications3 != null) {
                commentNotifications = commentNotifications3;
                return commentNotifications;
            }
        }
        commentNotifications = this.create(profileId, postId, enabled);
        return commentNotifications;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<PostId, CommentNotifications> findAllByProfileIdAndPostIdIn(@NotNull ProfileId profileId, @NotNull Collection<PostId> postIds) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        CommentNotificationsCrud commentNotificationsCrud = this.crud;
        if (commentNotificationsCrud == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
            commentNotificationsCrud = null;
        }
        Set entriesForAllPostIds = commentNotificationsCrud.getAllByProfileIdAndPostIdIn(profileId, CollectionsKt.toSet((Iterable)postIds));
        Iterable iterable = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object v1;
            Map map;
            Object t;
            block3: {
                PostId postId = (PostId)element$iv$iv;
                t = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                Iterable iterable2 = entriesForAllPostIds;
                for (Object t2 : iterable2) {
                    void postId2;
                    CommentNotifications it = (CommentNotifications)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPostId(), (Object)postId2)) continue;
                    v1 = t2;
                    break block3;
                }
                v1 = null;
            }
            CommentNotifications commentNotifications = v1;
            map.put(t, commentNotifications);
        }
        return result$iv;
    }

    @NotNull
    public CommentNotificationsReceivers getProfileIds(@NotNull PostId postId) {
        CommentNotifications it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        CommentNotificationsCrud commentNotificationsCrud = this.crud;
        if (commentNotificationsCrud == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crud");
            commentNotificationsCrud = null;
        }
        Iterable $this$partition$iv = commentNotificationsCrud.getAllByPostId(postId);
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            CommentNotifications it2 = (CommentNotifications)element$iv;
            boolean bl = false;
            boolean bl2 = it2.getEnabled() ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        boolean bl = false;
        List enabled = (List)pair.component1();
        List disabled = (List)pair.component2();
        Iterable $this$map$iv = enabled;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CommentNotifications commentNotifications = (CommentNotifications)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getProfileId());
        }
        $this$map$iv = disabled;
        collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommentNotifications)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            collection2.add(it.getProfileId());
        }
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Collection collection3 = collection;
        return new CommentNotificationsReceivers((Set)collection3, set);
    }
}

