/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.event.Attendance;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventAttendance;
import de.justsoftware.news.domain.event.EventAttendanceRepo;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.event.EventService;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.UserService;
import de.justsoftware.news.id.EventAttendanceId;
import de.justsoftware.news.id.EventId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.UidGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0017J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020!0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0017J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0019H\u0017J(\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/news/domain/event/EventService;", "", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "eventAttendanceRepo", "Lde/justsoftware/news/domain/event/EventAttendanceRepo;", "userService", "Lde/justsoftware/news/domain/user/UserService;", "<init>", "(Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/event/EventAttendanceRepo;Lde/justsoftware/news/domain/user/UserService;)V", "exportIcs", "", "eventId", "Lde/justsoftware/news/id/EventId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "updateEventAttendance", "Lde/justsoftware/news/domain/event/Event;", "attendance", "Lde/justsoftware/news/domain/event/Attendance;", "upsert", "", "user", "Lde/justsoftware/news/id/ProfileId;", "getAttendanceLists", "", "", "Lde/justsoftware/news/domain/event/EventAttendance;", "eventIds", "", "countByEventIdAndAttendingTrue", "", "findAttendance", "profileId", "getAttendees", "", "Lde/justsoftware/news/domain/user/Profile;", "news-service"})
@SourceDebugExtension(value={"SMAP\nEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventService.kt\nde/justsoftware/news/domain/event/EventService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,269:1\n1#2:270\n1#2:311\n1285#3,2:271\n1299#3,2:273\n774#3:275\n865#3,2:276\n1302#3:278\n1285#3,2:279\n1299#3,4:281\n1374#3:285\n1460#3,2:286\n1563#3:288\n1634#3,3:289\n1462#3,3:292\n774#3:298\n865#3,2:299\n1617#3,9:301\n1869#3:310\n1870#3:312\n1626#3:313\n126#4:295\n153#4,2:296\n155#4:314\n*S KotlinDebug\n*F\n+ 1 EventService.kt\nde/justsoftware/news/domain/event/EventService\n*L\n201#1:311\n166#1:271,2\n166#1:273,2\n167#1:275\n167#1:276,2\n166#1:278\n175#1:279,2\n175#1:281,4\n188#1:285\n188#1:286,2\n189#1:288\n189#1:289,3\n188#1:292,3\n200#1:298\n200#1:299,2\n201#1:301,9\n201#1:310\n201#1:312\n201#1:313\n197#1:295\n197#1:296,2\n197#1:314\n*E\n"})
public class EventService {
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final EventAttendanceRepo eventAttendanceRepo;
    @NotNull
    private final UserService userService;

    public EventService(@NotNull EventRepo eventRepo, @NotNull PostRepo postRepo, @NotNull EventAttendanceRepo eventAttendanceRepo, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)eventAttendanceRepo, (String)"eventAttendanceRepo");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.eventRepo = eventRepo;
        this.postRepo = postRepo;
        this.eventAttendanceRepo = eventAttendanceRepo;
        this.userService = userService;
    }

    @NotNull
    public String exportIcs(@NotNull EventId eventId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Event event = this.eventRepo.getById(eventId);
        Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
        authContext.checkPostAction(post, PostAction.EVENT_ICS_EXPORT);
        String summary = this.postRepo.getByIdAndDeletedFalse(event.getPostId()).getTitle();
        Component component = new VEvent((Temporal)event.getStartDate(), (Temporal)event.getEndDate(), summary).withProperty((Property)((UidGenerator)() -> EventService.exportIcs$lambda$0(event)).generateUid()).getFluentTarget();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type net.fortuna.ical4j.model.component.VEvent");
        VEvent vEvent = (VEvent)component;
        Duration minutesBeforeEventToStartAlarm = Duration.ofMinutes(-15L);
        Component component2 = new VAlarm((TemporalAmount)minutesBeforeEventToStartAlarm).withProperty((Property)new Action("DISPLAY")).withProperty((Property)new Description("Reminder")).getFluentTarget();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type net.fortuna.ical4j.model.component.VAlarm");
        VAlarm vAlarm = (VAlarm)component2;
        vEvent.setComponentList(new ComponentList(CollectionsKt.listOf((Object)vAlarm)));
        String string = new Calendar().withProdId("-//Just Software AG//Just Social//EN").withDefaults().withComponent((CalendarComponent)vEvent).getFluentTarget().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @Transactional
    @NotNull
    public Event updateEventAttendance(@NotNull EventId eventId, @NotNull AuthorizationContext authContext, @NotNull Attendance attendance) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)attendance, (String)"attendance");
        Event event = this.eventRepo.getById(eventId);
        authContext.checkRead((ItemId)event.getPostId());
        if (!event.getAttendanceEnabled()) {
            boolean bl = false;
            String string = "This event does not allow attendance";
            throw new IllegalArgumentException(string.toString());
        }
        if (WhenMappings.$EnumSwitchMapping$0[attendance.ordinal()] == 1) {
            this.eventAttendanceRepo.deleteByEventIdAndProfileId(eventId, authContext.getUser());
        } else {
            int currentAttendeeCount;
            if (event.getMaxAttendees() != null && !((currentAttendeeCount = this.eventAttendanceRepo.countByEventIdAndAttendingTrue(event.getId())) + 1 <= event.getMaxAttendees())) {
                boolean bl = false;
                String string = "This event is fully booked already. No slot left for: " + authContext.getUser();
                throw new IllegalArgumentException(string.toString());
            }
            this.upsert(event.getId(), authContext.getUser(), attendance);
        }
        return event;
    }

    private void upsert(EventId eventId, ProfileId user, Attendance attendance) {
        block3: {
            Instant now;
            block2: {
                now = Instant.now();
                EventAttendance eventAttendance = this.eventAttendanceRepo.findByEventIdAndProfileId(eventId, user);
                if (eventAttendance == null) break block2;
                EventAttendance it = eventAttendance;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)now);
                EventAttendance update = EventAttendance.copy$default((EventAttendance)it, null, null, null, null, (Instant)now, (boolean)attendance.toDb(), (int)15, null);
                EventAttendance eventAttendance2 = (EventAttendance)this.eventAttendanceRepo.save((Object)update);
                if (eventAttendance2 != null) break block3;
            }
            EventService $this$upsert_u24lambda_u244 = this;
            boolean bl = false;
            EventAttendanceRepo eventAttendanceRepo = $this$upsert_u24lambda_u244.eventAttendanceRepo;
            EventAttendanceId eventAttendanceId = EventAttendanceId.Companion.random();
            Intrinsics.checkNotNull((Object)now);
            eventAttendanceRepo.insert(eventAttendanceId, eventId, user, now, now, attendance.toDb());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<EventId, List<EventAttendance>> getAttendanceLists(@NotNull Collection<EventId> eventIds) {
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        Set attendanceList = this.eventAttendanceRepo.findByEventIdIn(eventIds);
        Iterable $this$associateWith$iv = eventIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            EventId eventId = (EventId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = attendanceList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void eventId2;
                EventAttendance attendance = (EventAttendance)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)attendance.getEventId(), (Object)eventId2)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<EventId, Integer> countByEventIdAndAttendingTrue(@NotNull Collection<EventId> eventIds) {
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        Iterable $this$associateWith$iv = eventIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            EventId eventId = (EventId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = this.eventAttendanceRepo.countByEventIdAndAttendingTrue((EventId)it);
            map.put(t, n);
        }
        return result$iv;
    }

    @Unauthorized
    @Nullable
    public EventAttendance findAttendance(@NotNull EventId eventId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.eventAttendanceRepo.findByEventIdAndProfileId(eventId, profileId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<EventId, Set<Profile>> getAttendees(@NotNull Set<EventId> eventIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        Map eventIdToAttendanceList = this.getAttendanceLists((Collection)eventIds);
        Iterable $this$flatMap$iv = eventIdToAttendanceList.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Object element$iv$iv = iterator.next();
            List attendanceListOfEvent = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = attendanceListOfEvent;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                EventAttendance eventAttendance = (EventAttendance)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getProfileId());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List listOfAllProfileIds = (List)destination$iv$iv;
        List profiles = this.userService.findProfilesByIds(listOfAllProfileIds);
        $this$flatMapTo$iv$iv = eventIdToAttendanceList;
        boolean $i$f$map = false;
        void $i$f$flatMapTo22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map.Entry item$iv$iv;
            Object item$iv$iv2;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            EventId eventId = (EventId)entry.getKey();
            List attendanceList = (List)entry.getValue();
            Iterable $i$f$mapTo2 = attendanceList;
            boolean $i$f$filter = false;
            item$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EventAttendance it = (EventAttendance)element$iv$iv;
                boolean bl3 = false;
                if (!(Attendance.Companion.fromDb(it.getAttending()) == Attendance.YES)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Profile it$iv$iv;
                Object v0;
                block6: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    EventAttendance it = (EventAttendance)element$iv$iv;
                    boolean bl5 = false;
                    Iterable iterable3 = profiles;
                    for (Object t : iterable3) {
                        Profile profile = (Profile)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)profile.getId(), (Object)it.getProfileId())) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                if ((Profile)v0 == null) continue;
                boolean bl7 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            Set attendanceProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
            collection.add(TuplesKt.to((Object)eventId, (Object)attendanceProfiles));
        }
        Map eventIdToActualAttendees = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
        return eventIdToActualAttendees;
    }

    private static final Uid exportIcs$lambda$0(Event $event) {
        return new Uid($event.getId().toTypedString());
    }
}

