/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.csv.CsvExportLanguage;
import de.justsoftware.news.domain.event.Attendance;
import de.justsoftware.news.domain.event.AttendeeCountDataLoader;
import de.justsoftware.news.domain.event.AttendeesDataLoader;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventAttendance;
import de.justsoftware.news.domain.event.EventCsvExportService;
import de.justsoftware.news.domain.event.EventDataFetcherKt;
import de.justsoftware.news.domain.event.EventService;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.id.EventId;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u001a\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/event/EventDataFetcher;", "", "eventService", "Lde/justsoftware/news/domain/event/EventService;", "eventCsvExportService", "Lde/justsoftware/news/domain/event/EventCsvExportService;", "<init>", "(Lde/justsoftware/news/domain/event/EventService;Lde/justsoftware/news/domain/event/EventCsvExportService;)V", "updateEventAttendance", "Lde/justsoftware/news/graphql/generated/types/Event;", "eventId", "Lde/justsoftware/news/id/EventId;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "attendance", "Lde/justsoftware/news/domain/event/Attendance;", "icsExportFileUrl", "", "icsExportString", "isAttending", "attendees", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/graphql/generated/types/Profile;", "attendeeCount", "", "csvExportString", "language", "Lde/justsoftware/news/domain/csv/CsvExportLanguage;", "csvExportFileUrl", "news-service"})
public class EventDataFetcher {
    @NotNull
    private final EventService eventService;
    @NotNull
    private final EventCsvExportService eventCsvExportService;

    public EventDataFetcher(@NotNull EventService eventService, @NotNull EventCsvExportService eventCsvExportService) {
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)eventCsvExportService, (String)"eventCsvExportService");
        this.eventService = eventService;
        this.eventCsvExportService = eventCsvExportService;
    }

    @DgsMutation(field="updateEventAttendance")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Event updateEventAttendance(@NotNull EventId eventId, @NotNull DgsDataFetchingEnvironment dfe, @NotNull Attendance attendance) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)attendance, (String)"attendance");
        return EventDataFetcherKt.toGql((Event)this.eventService.updateEventAttendance(eventId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe), attendance));
    }

    @DgsData(parentType="Event", field="icsExportFileUrl")
    @NotNull
    public String icsExportFileUrl(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String eventId = ((de.justsoftware.news.graphql.generated.types.Event)dfe.getSourceOrThrow()).getId().toTypedString();
        return "/news/rest/event/" + eventId + "/ics-export";
    }

    @DgsData(parentType="Event", field="icsExportString")
    @NotNull
    public String icsExportString(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.eventService.exportIcs(((de.justsoftware.news.graphql.generated.types.Event)dfe.getSourceOrThrow()).getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="EventAttendance", field="attending")
    @NotNull
    public Attendance isAttending(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        EventId eventId = ((de.justsoftware.news.graphql.generated.types.EventAttendance)dfe.getSourceOrThrow()).getEventId();
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        EventAttendance eventAttendance = this.eventService.findAttendance(eventId, authContext.getUser());
        EventAttendance eventAttendance2 = eventAttendance;
        if (eventAttendance2 == null || (eventAttendance2 = eventAttendance2.getAttendanceEnum()) == null) {
            eventAttendance2 = Attendance.UNDECIDED;
        }
        return eventAttendance2;
    }

    @DgsData(parentType="EventAttendance", field="attendees")
    @NotNull
    public CompletableFuture<List<Profile>> attendees(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        EventId eventId = ((de.justsoftware.news.graphql.generated.types.EventAttendance)dfe.getSourceOrThrow()).getEventId();
        DataLoader dataLoader = dfe.getDataLoader(AttendeesDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)eventId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="EventAttendance", field="attendeeCount")
    @NotNull
    public CompletableFuture<Integer> attendeeCount(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        EventId eventId = ((de.justsoftware.news.graphql.generated.types.EventAttendance)dfe.getSourceOrThrow()).getEventId();
        DataLoader dataLoader = dfe.getDataLoader(AttendeeCountDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)eventId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="EventAttendance", field="csvExportString")
    @NotNull
    public String csvExportString(@InputArgument @NotNull CsvExportLanguage language, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.eventCsvExportService.export(((de.justsoftware.news.graphql.generated.types.EventAttendance)dfe.getSourceOrThrow()).getEventId(), language, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getCsvContent();
    }

    @DgsData(parentType="EventAttendance", field="csvExportFileUrl")
    @NotNull
    public String csvExportFileUrl(@InputArgument @NotNull CsvExportLanguage language, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String eventId = ((de.justsoftware.news.graphql.generated.types.EventAttendance)dfe.getSourceOrThrow()).getEventId().toTypedString();
        return "/news/rest/event/" + eventId + "/csv-export?language=" + language;
    }
}

