/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.deepl;

import com.deepl.api.DeepLException;
import com.deepl.api.TextResult;
import com.deepl.api.TextTranslationOptions;
import de.justsoftware.news.connector.deepl.DeepLClientFactory;
import de.justsoftware.news.connector.deepl.DeepLConnector;
import de.justsoftware.news.connector.deepl.TranslationResult;
import de.justsoftware.news.util.Quill2XmlConverter;
import de.justsoftware.news.util.QuillDelta;
import de.justsoftware.news.util.QuillUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J6\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J*\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/news/connector/deepl/DeepLConnector;", "", "deepLClientFactory", "Lde/justsoftware/news/connector/deepl/DeepLClientFactory;", "quill2XmlConverter", "Lde/justsoftware/news/util/Quill2XmlConverter;", "<init>", "(Lde/justsoftware/news/connector/deepl/DeepLClientFactory;Lde/justsoftware/news/util/Quill2XmlConverter;)V", "translateText", "Lde/justsoftware/news/connector/deepl/TranslationResult;", "text", "", "sourceLanguage", "targetLanguage", "deepLApiKey", "", "texts", "translateQuillDelta", "quillDeltaJson", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nDeepLConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepLConnector.kt\nde/justsoftware/news/connector/deepl/DeepLConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1563#2:135\n1634#2,3:136\n*S KotlinDebug\n*F\n+ 1 DeepLConnector.kt\nde/justsoftware/news/connector/deepl/DeepLConnector\n*L\n52#1:135\n52#1:136,3\n*E\n"})
public class DeepLConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeepLClientFactory deepLClientFactory;
    @NotNull
    private final Quill2XmlConverter quill2XmlConverter;

    public DeepLConnector(@NotNull DeepLClientFactory deepLClientFactory, @NotNull Quill2XmlConverter quill2XmlConverter) {
        Intrinsics.checkNotNullParameter((Object)deepLClientFactory, (String)"deepLClientFactory");
        Intrinsics.checkNotNullParameter((Object)quill2XmlConverter, (String)"quill2XmlConverter");
        this.deepLClientFactory = deepLClientFactory;
        this.quill2XmlConverter = quill2XmlConverter;
    }

    @NotNull
    public TranslationResult translateText(@NotNull String text, @Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String deepLApiKey) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deepLApiKey, (String)"deepLApiKey");
        return (TranslationResult)this.translateText(CollectionsKt.listOf((Object)text), sourceLanguage, targetLanguage, deepLApiKey).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TranslationResult> translateText(@NotNull List<String> texts, @Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String deepLApiKey) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deepLApiKey, (String)"deepLApiKey");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = this.deepLClientFactory.client(deepLApiKey).translateText(texts, sourceLanguage, Companion.access$sanitizeTargetLanguage((Companion)Companion, (String)targetLanguage));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"translateText(...)");
            iterable = list;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextResult textResult = (TextResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = it.getDetectedSourceLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDetectedSourceLanguage(...)");
                collection.add(new TranslationResult(string, Companion.access$sanitizeDetectedSourceLanguage((Companion)Companion, (String)string2)));
            }
            iterable = (List)destination$iv$iv;
        }
        catch (DeepLException e) {
            throw Companion.access$toTranslationException((Companion)Companion, (DeepLException)e);
        }
        return iterable;
    }

    @NotNull
    public TranslationResult translateQuillDelta(@NotNull String quillDeltaJson, @Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String deepLApiKey) {
        Intrinsics.checkNotNullParameter((Object)quillDeltaJson, (String)"quillDeltaJson");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deepLApiKey, (String)"deepLApiKey");
        try {
            Object object = QuillUtilsKt.toDelta((String)quillDeltaJson);
            ResultKt.throwOnFailure((Object)object);
            Pair pair = this.quill2XmlConverter.toXml((QuillDelta)object);
            String sourceXmlContent = (String)pair.component1();
            Map context = (Map)pair.component2();
            TextResult translateXmlResult = this.deepLClientFactory.client(deepLApiKey).translateText(sourceXmlContent, sourceLanguage, Companion.access$sanitizeTargetLanguage((Companion)Companion, (String)targetLanguage), new TextTranslationOptions().setTagHandling("xml").setNonSplittingTags((Iterable)CollectionsKt.listOf((Object)"text")).setIgnoreTags((Iterable)CollectionsKt.listOf((Object)"meta")));
            String string = translateXmlResult.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = QuillUtilsKt.toJson((QuillDelta)this.quill2XmlConverter.toQuillDelta(string, context));
            String string3 = translateXmlResult.getDetectedSourceLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDetectedSourceLanguage(...)");
            return new TranslationResult(string2, Companion.access$sanitizeDetectedSourceLanguage((Companion)Companion, (String)string3));
        }
        catch (DeepLException e) {
            throw Companion.access$toTranslationException((Companion)Companion, (DeepLException)e);
        }
    }
}

