/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.app.model.remote.ApiApp;
import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.people.generated.apis.ProfileControllerApi;
import de.justsoftware.mobile.gateway.people.generated.apis.UserGroupControllerApi;
import de.justsoftware.mobile.gateway.people.generated.models.AbsenceDto;
import de.justsoftware.mobile.gateway.people.generated.models.PagedResultBirthdayProfile;
import de.justsoftware.mobile.gateway.people.generated.models.PagedResultProfile;
import de.justsoftware.mobile.gateway.people.generated.models.PagedResultProfileSearchResult;
import de.justsoftware.mobile.gateway.people.generated.models.PagedResultUserGroupDto;
import de.justsoftware.mobile.gateway.people.generated.models.Profile;
import de.justsoftware.mobile.gateway.people.generated.models.UserGroupDto;
import de.justsoftware.mobile.gateway.people.model.local.AbsenceInformation;
import de.justsoftware.mobile.gateway.people.model.local.BirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfilePermissions;
import de.justsoftware.mobile.gateway.people.model.local.ProfilePersonalData;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceNoteData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceStatusData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateBirthdayData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileDetailsData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileSectionData;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.AbsenceDtosKt;
import de.justsoftware.mobile.gateway.people.model.remote.AbsenceNoteUpdateDtosKt;
import de.justsoftware.mobile.gateway.people.model.remote.AbsenceStatusUpdateDtosKt;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyMobilePeopleUpdatedProfileData;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfilePersonalData;
import de.justsoftware.mobile.gateway.people.model.remote.PagedResultBirthdayProfilesKt;
import de.justsoftware.mobile.gateway.people.model.remote.PagedResultProfileSearchResultsKt;
import de.justsoftware.mobile.gateway.people.model.remote.PagedResultProfilesKt;
import de.justsoftware.mobile.gateway.people.model.remote.PagedResultUserGroupDtosKt;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfilesKt;
import de.justsoftware.mobile.gateway.people.model.remote.UserGroupDtosKt;
import de.justsoftware.mobile.gateway.people.service.LegacyMobilePeopleApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0015H\u0016J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J \u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020,0\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001d2\u0006\u00106\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\"\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00150;H\u0016J\u0018\u0010<\u001a\u0002092\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u0002092\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010@\u001a\u00020AH\u0016J \u0010B\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010G\u001a\u00020F2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0015H\u0012J\u0018\u0010K\u001a\u00020L2\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0015H\u0012J\u001a\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "", "mobilePeopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/LegacyMobilePeopleApiGatewayService;", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "peopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "profileApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;", "profileControllerApi", "Lde/justsoftware/mobile/gateway/people/generated/apis/ProfileControllerApi;", "userGroupControllerApi", "Lde/justsoftware/mobile/gateway/people/generated/apis/UserGroupControllerApi;", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "<init>", "(Lde/justsoftware/mobile/gateway/people/service/LegacyMobilePeopleApiGatewayService;Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;Lde/justsoftware/mobile/gateway/people/generated/apis/ProfileControllerApi;Lde/justsoftware/mobile/gateway/people/generated/apis/UserGroupControllerApi;Lde/justsoftware/mobile/gateway/common/service/UrlService;)V", "getProfileDetails", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "profileId", "", "currentUserId", "updateProfileDetails", "updateProfileDetailsData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileDetailsData;", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "getProfiles", "", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "getAttributes", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "updateAttribute", "updateAttributeData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileSectionData;", "deleteAttributes", "sectionKey", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/BirthdayProfile;", "currentDate", "getAbsenceInformation", "", "Lde/justsoftware/mobile/gateway/people/model/local/AbsenceInformation;", "profileIds", "", "updateAbsenceNote", "updateAbsenceNoteData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceNoteData;", "updateAbsenceStatus", "updateAbsenceStatusData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceStatusData;", "updateBirthday", "updateBirthdayData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateBirthdayData;", "enableBirthdayReminderForProfile", "", "disableBirthdayReminderForProfile", "suggestProfiles", "apiProfile", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiProfile;", "getProfilePermissions", "Lde/justsoftware/mobile/gateway/people/model/local/ProfilePermissions;", "getProfilePersonalData", "Lde/justsoftware/mobile/gateway/people/model/local/ProfilePersonalData;", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1563#2:368\n1634#2,3:369\n*S KotlinDebug\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n*L\n302#1:368\n302#1:369,3\n*E\n"})
public class PeopleService {
    @NotNull
    private final LegacyMobilePeopleApiGatewayService mobilePeopleApiGatewayService;
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;
    @NotNull
    private final PeopleApiGatewayService peopleApiGatewayService;
    @NotNull
    private final LegacyProfileApiGatewayService profileApiGatewayService;
    @NotNull
    private final ProfileControllerApi profileControllerApi;
    @NotNull
    private final UserGroupControllerApi userGroupControllerApi;
    @NotNull
    private final UrlService urlService;

    public PeopleService(@NotNull LegacyMobilePeopleApiGatewayService mobilePeopleApiGatewayService, @NotNull ToroApiGatewayService toroApiGatewayService, @NotNull PeopleApiGatewayService peopleApiGatewayService, @NotNull LegacyProfileApiGatewayService profileApiGatewayService, @NotNull ProfileControllerApi profileControllerApi, @NotNull UserGroupControllerApi userGroupControllerApi, @NotNull UrlService urlService) {
        Intrinsics.checkNotNullParameter((Object)mobilePeopleApiGatewayService, (String)"mobilePeopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)peopleApiGatewayService, (String)"peopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)profileApiGatewayService, (String)"profileApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)profileControllerApi, (String)"profileControllerApi");
        Intrinsics.checkNotNullParameter((Object)userGroupControllerApi, (String)"userGroupControllerApi");
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        this.mobilePeopleApiGatewayService = mobilePeopleApiGatewayService;
        this.toroApiGatewayService = toroApiGatewayService;
        this.peopleApiGatewayService = peopleApiGatewayService;
        this.profileApiGatewayService = profileApiGatewayService;
        this.profileControllerApi = profileControllerApi;
        this.userGroupControllerApi = userGroupControllerApi;
        this.urlService = urlService;
    }

    @NotNull
    public ProfileDetails getProfileDetails(@NotNull String profileId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return this.getProfileDetails(this.profileApiGatewayService.getProfile(profileId), currentUserId);
    }

    @NotNull
    public ProfileDetails updateProfileDetails(@NotNull String profileId, @NotNull UpdateProfileDetailsData updateProfileDetailsData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateProfileDetailsData, (String)"updateProfileDetailsData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.mobilePeopleApiGatewayService.updateProfile(profileId, LegacyMobilePeopleUpdatedProfileData.Companion.toLegacyMobilePeopleUpdatedProfileData(updateProfileDetailsData));
        return this.getProfileDetails(profileId, currentUserId);
    }

    @NotNull
    public de.justsoftware.mobile.gateway.people.model.local.Profile getProfile(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return PeopleApiProfilesKt.toProfile((Profile)this.profileControllerApi.getProfile(profileId));
    }

    @NotNull
    public List<de.justsoftware.mobile.gateway.people.model.local.Profile> getProfiles(@Nullable String query, int offset, int limit) {
        return PagedResultProfileSearchResultsKt.toProfiles((PagedResultProfileSearchResult)ProfileControllerApi.getProfiles$default((ProfileControllerApi)this.profileControllerApi, (String)query, null, (Integer)offset, (Integer)limit, (int)2, null));
    }

    @NotNull
    public List<UserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        return PagedResultUserGroupDtosKt.toUserGroups((PagedResultUserGroupDto)this.userGroupControllerApi.getAllGroups(offset, limit, query), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public UserGroup getUserGroup(@NotNull String groupId) {
        UserGroup userGroup;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        UserGroupDto userGroupDto = this.userGroupControllerApi.getGroup(groupId).getUserGroup();
        if (userGroupDto == null || (userGroup = UserGroupDtosKt.toUserGroup((UserGroupDto)userGroupDto, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */))) == null) {
            throw new NotFoundException("No user group with id: " + groupId);
        }
        return userGroup;
    }

    @NotNull
    public List<de.justsoftware.mobile.gateway.people.model.local.Profile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return PagedResultProfilesKt.toProfiles((PagedResultProfile)UserGroupControllerApi.getUserGroupMembersForGroup$default((UserGroupControllerApi)this.userGroupControllerApi, (String)groupId, (int)offset, (int)limit, null, (int)8, null));
    }

    @NotNull
    public ProfileDetails updateUserImage(@NotNull String profileId, @NotNull MultipartFile image, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return this.getProfileDetails(this.profileApiGatewayService.updateUserImage(profileId, image), currentUserId);
    }

    @NotNull
    public ProfileDetails deleteUserImage(@NotNull String profileId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return this.getProfileDetails(this.profileApiGatewayService.deleteUserImage(profileId), currentUserId);
    }

    @NotNull
    public List<ProfileSection> getAttributes(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return ProfileSection.Companion.toProfileSections(this.profileApiGatewayService.getProfileAttributes(profileId));
    }

    @NotNull
    public List<ProfileSection> updateAttribute(@NotNull String profileId, @NotNull UpdateProfileSectionData updateAttributeData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAttributeData, (String)"updateAttributeData");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<ProfileSection> deleteAttributes(@NotNull String profileId, @NotNull String sectionKey) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sectionKey, (String)"sectionKey");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public ProfileConfiguration getConfiguration(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (ProfileConfiguration)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<BirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        LocalDate localDate = LocalDate.parse(currentDate);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
        return PagedResultBirthdayProfilesKt.toBirthdayProfiles((PagedResultBirthdayProfile)this.profileControllerApi.getBirthdayProfiles(localDate, Integer.valueOf(offset), Integer.valueOf(limit)));
    }

    @NotNull
    public Map<String, AbsenceInformation> getAbsenceInformation(@NotNull Set<String> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return AbsenceDtosKt.toAbsenceInformation((Map)this.profileControllerApi.getAbsenceInformation(profileIds));
    }

    @NotNull
    public AbsenceInformation updateAbsenceNote(@NotNull String profileId, @NotNull UpdateAbsenceNoteData updateAbsenceNoteData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceNoteData, (String)"updateAbsenceNoteData");
        return AbsenceDtosKt.toAbsenceInformation((AbsenceDto)this.profileControllerApi.changeAbsenceNote(profileId, AbsenceNoteUpdateDtosKt.toAbsenceNoteUpdateDto((UpdateAbsenceNoteData)updateAbsenceNoteData)));
    }

    @NotNull
    public AbsenceInformation updateAbsenceStatus(@NotNull String profileId, @NotNull UpdateAbsenceStatusData updateAbsenceStatusData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceStatusData, (String)"updateAbsenceStatusData");
        return AbsenceDtosKt.toAbsenceInformation((AbsenceDto)this.profileControllerApi.changeAbsenceStatus(profileId, AbsenceStatusUpdateDtosKt.toAbsenceStatusUpdateDto((UpdateAbsenceStatusData)updateAbsenceStatusData)));
    }

    @NotNull
    public ProfileDetails updateBirthday(@NotNull String profileId, @NotNull UpdateBirthdayData updateBirthdayData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateBirthdayData, (String)"updateBirthdayData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.profileApiGatewayService.updatePersonalData(profileId, LegacyProfilePersonalData.Companion.toLegacyProfilePersonalData(updateBirthdayData));
        return this.getProfileDetails(profileId, currentUserId);
    }

    public void enableBirthdayReminderForProfile(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileControllerApi.saveBirthdayReminderForProfile(profileId);
    }

    public void disableBirthdayReminderForProfile(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileControllerApi.deleteBirthdayReminderForProfile(profileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<de.justsoftware.mobile.gateway.people.model.local.Profile> suggestProfiles(@NotNull String query, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Iterable iterable = this.peopleApiGatewayService.suggestProfiles(query, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiProfile;
            PeopleApiProfile peopleApiProfile = (PeopleApiProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PeopleApiProfile.Companion.toProfile((PeopleApiProfile)apiProfile));
        }
        return (List)destination$iv$iv;
    }

    private ProfileDetails getProfileDetails(LegacyProfileApiProfile apiProfile, String currentUserId) {
        return (ProfileDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private ProfilePermissions getProfilePermissions(LegacyProfileApiProfile apiProfile, String currentUserId) {
        boolean chatEnabled = ApiApp.Companion.chatEnabled(this.toroApiGatewayService.getAvailableApps());
        return ProfilePermissions.Companion.profilePermissionsOf(chatEnabled && !Intrinsics.areEqual((Object)apiProfile.getId(), (Object)currentUserId), LegacyProfileApiProfile.Companion.isEditProfileAllowed(apiProfile));
    }

    private ProfilePersonalData getProfilePersonalData(String profileId, String currentUserId) {
        ProfilePersonalData profilePersonalData;
        if (!Intrinsics.areEqual((Object)profileId, (Object)currentUserId)) {
            profilePersonalData = null;
        } else {
            PeopleService peopleService;
            Object $this$getProfilePersonalData_u24lambda_u240;
            PeopleService peopleService2 = this;
            try {
                $this$getProfilePersonalData_u24lambda_u240 = peopleService2;
                boolean bl = false;
                $this$getProfilePersonalData_u24lambda_u240 = Result.constructor-impl((Object)ProfilePersonalData.Companion.toProfilePersonalData($this$getProfilePersonalData_u24lambda_u240.profileApiGatewayService.getPersonalData(profileId)));
            }
            catch (Throwable bl) {
                $this$getProfilePersonalData_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            peopleService2 = $this$getProfilePersonalData_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)peopleService2);
            if (throwable == null) {
                peopleService = peopleService2;
            } else {
                Throwable error = throwable;
                boolean bl = false;
                if (error instanceof ForbiddenException) {
                    peopleService = null;
                } else {
                    throw error;
                }
            }
            profilePersonalData = (ProfilePersonalData)peopleService;
        }
        return profilePersonalData;
    }

    public static final /* synthetic */ LegacyMobilePeopleApiGatewayService access$getMobilePeopleApiGatewayService$p(PeopleService $this) {
        return $this.mobilePeopleApiGatewayService;
    }

    public static final /* synthetic */ LegacyProfileApiGatewayService access$getProfileApiGatewayService$p(PeopleService $this) {
        return $this.profileApiGatewayService;
    }

    public static final /* synthetic */ ProfilePermissions access$getProfilePermissions(PeopleService $this, LegacyProfileApiProfile apiProfile, String currentUserId) {
        return $this.getProfilePermissions(apiProfile, currentUserId);
    }

    public static final /* synthetic */ ProfilePersonalData access$getProfilePersonalData(PeopleService $this, String profileId, String currentUserId) {
        return $this.getProfilePersonalData(profileId, currentUserId);
    }

    public static final /* synthetic */ UrlService access$getUrlService$p(PeopleService $this) {
        return $this.urlService;
    }
}

