/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.drive.model.local.AddFolderData;
import de.justsoftware.mobile.gateway.drive.model.local.Document;
import de.justsoftware.mobile.gateway.drive.model.local.DriveId;
import de.justsoftware.mobile.gateway.drive.model.local.FolderDetails;
import de.justsoftware.mobile.gateway.drive.model.local.Share;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiDocument;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiFolderDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShare;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShares;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/justsoftware/mobile/gateway/drive/service/DriveService;", "", "driveApiGatewayService", "Lde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService;", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "<init>", "(Lde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService;Lde/justsoftware/mobile/gateway/common/service/UrlService;)V", "getShare", "Lde/justsoftware/mobile/gateway/drive/model/local/Share;", "shareId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$Share;", "getShares", "", "offset", "", "limit", "subscribeToShare", "unsubscribeFromShare", "getFolderDetails", "Lde/justsoftware/mobile/gateway/drive/model/local/FolderDetails;", "folderId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$DriveDocument;", "addFolder", "", "parentFolderId", "addFolderData", "Lde/justsoftware/mobile/gateway/drive/model/local/AddFolderData;", "getDocument", "Lde/justsoftware/mobile/gateway/drive/model/local/Document;", "documentId", "deleteDocument", "", "getDownloadAttachmentUri", "Ljava/net/URI;", "getDownloadAttachmentPreviewUri", "getDownloadAttachmentVideoStreamUrl", "getUnauthorizedAttachmentVideoUrl", "uploadTemporaryFile", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$TempFile;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "setVideoTeaser", "videoId", "removeVideoTeaser", "", "uploadToFolder", "mobile-gateway"})
public class DriveService {
    @NotNull
    private final DriveApiGatewayService driveApiGatewayService;
    @NotNull
    private final UrlService urlService;

    public DriveService(@NotNull DriveApiGatewayService driveApiGatewayService, @NotNull UrlService urlService) {
        Intrinsics.checkNotNullParameter((Object)driveApiGatewayService, (String)"driveApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        this.driveApiGatewayService = driveApiGatewayService;
        this.urlService = urlService;
    }

    @NotNull
    public Share getShare(@NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        return ApiShare.Companion.toShare(this.driveApiGatewayService.getShare(shareId));
    }

    @NotNull
    public List<Share> getShares(int offset, int limit) {
        return ApiShares.Companion.toShares(this.driveApiGatewayService.getShares(offset, limit));
    }

    public static /* synthetic */ List getShares$default(DriveService driveService, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getShares");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 20;
        }
        return driveService.getShares(n, n2);
    }

    @Nullable
    public Share subscribeToShare(@NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        this.driveApiGatewayService.subscribeToShare(shareId);
        return this.getShare(shareId);
    }

    @Nullable
    public Share unsubscribeFromShare(@NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        this.driveApiGatewayService.unsubscribeFromShare(shareId);
        return this.getShare(shareId);
    }

    @NotNull
    public FolderDetails getFolderDetails(@NotNull DriveId.DriveDocument folderId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        return ApiFolderDetails.Companion.toFolderDetails(this.driveApiGatewayService.getFolderDetails(folderId, offset, limit), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public String addFolder(@NotNull DriveId.DriveDocument parentFolderId, @NotNull AddFolderData addFolderData) {
        Intrinsics.checkNotNullParameter((Object)parentFolderId, (String)"parentFolderId");
        Intrinsics.checkNotNullParameter((Object)addFolderData, (String)"addFolderData");
        return this.driveApiGatewayService.addFolder(parentFolderId, addFolderData.getName());
    }

    @NotNull
    public Document getDocument(@NotNull DriveId.DriveDocument documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return ApiDocument.Companion.toDocument(this.driveApiGatewayService.getDocumentDetails(documentId), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteDocument(@NotNull DriveId.DriveDocument documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        this.driveApiGatewayService.deleteDocument(documentId);
    }

    @NotNull
    public URI getDownloadAttachmentUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveApiGatewayService.getDownloadAttachmentUri(documentId);
    }

    @NotNull
    public URI getDownloadAttachmentPreviewUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveApiGatewayService.getDownloadAttachmentPreviewUri(documentId);
    }

    @NotNull
    public String getDownloadAttachmentVideoStreamUrl(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveApiGatewayService.getDownloadAttachmentVideoStreamUrl(documentId);
    }

    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveApiGatewayService.getUnauthorizedAttachmentVideoUrl(documentId);
    }

    @NotNull
    public DriveId.TempFile uploadTemporaryFile(@NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveApiGatewayService.uploadTemporaryFiles(file);
    }

    @NotNull
    public DriveId.DriveDocument setVideoTeaser(@NotNull DriveId.DriveDocument videoId, @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveApiGatewayService.setVideoTeaser(videoId, file);
    }

    public boolean removeVideoTeaser(@NotNull DriveId.DriveDocument videoId) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        return this.driveApiGatewayService.removeVideoTeaser(videoId);
    }

    @NotNull
    public DriveId.DriveDocument uploadToFolder(@NotNull DriveId.DriveDocument folderId, @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveApiGatewayService.uploadToFolder(folderId, file);
    }
}

