/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.service;

import de.justsoftware.mobile.gateway.drive.model.local.DriveId;
import de.justsoftware.mobile.gateway.drive.model.local.DriveIdType;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiAddFolderData;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiDocumentDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiFolderDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShare;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShares;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u0017H\u0016J&\u0010-\u001a\u0002H.\"\u0006\b\u0000\u0010.\u0018\u00012\u0006\u0010/\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0092\b\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0018\u00102\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u00103\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0010\u00104\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0012J \u00105\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u00106\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0010\u00107\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u0003H\u0012J\u0010\u0010:\u001a\u00020 2\u0006\u00109\u001a\u00020\u0017H\u0012J\u0010\u0010;\u001a\u00020 2\u0006\u00109\u001a\u00020\u0003H\u0012J\u0010\u0010<\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0012J\u0010\u0010=\u001a\u00020 2\u0006\u00109\u001a\u00020\u0003H\u0012J\b\u0010>\u001a\u00020 H\u0012J\u0010\u0010?\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\b\u0010@\u001a\u00020 H\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService;", "", "driveApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getShare", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShare;", "shareId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$Share;", "getShares", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShares;", "offset", "", "limit", "subscribeToShare", "", "unsubscribeFromShare", "getFolderDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiFolderDetails;", "folderId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$DriveDocument;", "addFolder", "parentFolderId", "folderName", "getDocumentDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiDocumentDetails;", "documentId", "deleteDocument", "getDownloadAttachmentUri", "Ljava/net/URI;", "getDownloadAttachmentPreviewUri", "getDownloadAttachmentVideoStreamUrl", "getUnauthorizedAttachmentVideoUrl", "uploadTemporaryFiles", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$TempFile;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "uploadToFolder", "setVideoTeaser", "videoId", "removeVideoTeaser", "", "uploadFile", "T", "uri", "(Ljava/net/URI;Lorg/springframework/web/multipart/MultipartFile;)Ljava/lang/Object;", "shareUri", "sharesUri", "subscribeToShareUri", "unsubscribeFromShareUri", "folderDetailsUri", "documentDetailsUri", "deleteDocumentUri", "downloadAttachmentUri", "id", "videoTeaserUri", "downloadAttachmentPreviewUri", "downloadAttachmentVideoStreamUrl", "driveAccessTokenUri", "tempFileUploadUri", "folderUploadUri", "addFolderUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nDriveApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n128#1,4:208\n128#1,4:213\n128#1,4:218\n52#2:198\n52#2:199\n61#2:200\n61#2:201\n52#2:202\n64#2:203\n52#2:204\n95#2:205\n58#2:206\n64#2:212\n64#2:217\n64#2:222\n95#2:223\n64#2:224\n1#3:207\n*S KotlinDebug\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n*L\n101#1:208,4\n111#1:213,4\n117#1:218,4\n29#1:198\n35#1:199\n43#1:200\n47#1:201\n56#1:202\n69#1:203\n78#1:204\n81#1:205\n95#1:206\n101#1:212\n111#1:217\n117#1:222\n125#1:223\n131#1:224\n*E\n"})
public class DriveApiGatewayService {
    @Value(value="${just.drive.api.url}")
    @NotNull
    private final String driveApiUrl;
    @NotNull
    private final WebClient webClient;

    public DriveApiGatewayService(@Value(value="${just.drive.api.url}") @NotNull String driveApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)driveApiUrl, (String)"driveApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.driveApiUrl = driveApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShare getShare(@NotNull DriveId.Share shareId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.shareUri(shareId.getFullyQualifiedId());
        boolean $i$f$get = false;
        return (ApiShare)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShares getShares(int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.sharesUri(offset, limit);
        boolean $i$f$get = false;
        return (ApiShares)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeToShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.subscribeToShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeFromShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.unsubscribeFromShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiFolderDetails getFolderDetails(@NotNull DriveId.DriveDocument folderId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        WebClient webClient = this.webClient;
        URI uRI = this.folderDetailsUri(folderId.getId(), offset, limit);
        boolean $i$f$get = false;
        return (ApiFolderDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String addFolder(@NotNull DriveId.DriveDocument parentFolderId, @NotNull String folderName) {
        void body$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)parentFolderId, (String)"parentFolderId");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        WebClient webClient = this.webClient;
        URI uRI = this.addFolderUri();
        ApiAddFolderData apiAddFolderData = ApiAddFolderData.Companion.apiAddFolderDataOf(parentFolderId, folderName);
        boolean $i$f$post = false;
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiDocumentDetails getDocumentDetails(@NotNull DriveId.DriveDocument documentId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.documentDetailsUri(documentId.getId());
        boolean $i$f$get = false;
        return (ApiDocumentDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteDocument(@NotNull DriveId.DriveDocument documentId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteDocumentUri(documentId.getId());
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public URI getDownloadAttachmentUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public URI getDownloadAttachmentPreviewUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentPreviewUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public String getDownloadAttachmentVideoStreamUrl(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentVideoStreamUrl(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@NotNull String documentId) {
        Object object;
        block3: {
            block2: {
                void $this$getOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                Object object2 = this.webClient;
                URI uri$iv = this.driveAccessTokenUri(DriveIdType.Companion.removeDriveIdType(documentId));
                boolean $i$f$getOrNull = false;
                String string = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
                if (string == null) break block2;
                object = new char[]{'\"'};
                object2 = StringsKt.trim((String)string, (char[])object);
                if (object2 == null) break block2;
                Object accessToken = object2;
                boolean bl = false;
                object = "/drive/api/unauthenticated/previewVideoFile/" + (String)accessToken;
                if (object != null) break block3;
            }
            throw new NotFoundException("Could not get accessToken for document: " + documentId);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DriveId.TempFile uploadTemporaryFiles(@NotNull MultipartFile file) {
        void uri$iv$iv;
        void $this$post$iv$iv;
        void uri$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DriveApiGatewayService driveApiGatewayService = this;
        URI uRI = this.tempFileUploadUri();
        MultipartFile file$iv = file;
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder$iv = new MultipartBodyBuilder();
        builder$iv.part("files", (Object)file$iv.getResource());
        WebClient webClient = this_$iv.webClient;
        void var9_8 = uri$iv;
        MultiValueMap multiValueMap = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv$iv = multiValueMap;
        boolean $i$f$post = false;
        List ids = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        if (ids.size() > 1) {
            throw new IllegalStateException("Received " + ids.size() + " ids for " + file.getOriginalFilename());
        }
        return (DriveId.TempFile)CollectionsKt.first((List)ids);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DriveId.DriveDocument uploadToFolder(@NotNull DriveId.DriveDocument folderId, @NotNull MultipartFile file) {
        void uri$iv$iv;
        void $this$post$iv$iv;
        void uri$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DriveApiGatewayService driveApiGatewayService = this;
        URI uRI = this.folderUploadUri(folderId);
        MultipartFile file$iv = file;
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder$iv = new MultipartBodyBuilder();
        builder$iv.part("files", (Object)file$iv.getResource());
        WebClient webClient = this_$iv.webClient;
        void var9_9 = uri$iv;
        MultiValueMap multiValueMap = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv$iv = multiValueMap;
        boolean $i$f$post = false;
        return (DriveId.DriveDocument)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DriveId.DriveDocument setVideoTeaser(@NotNull DriveId.DriveDocument videoId, @NotNull MultipartFile file) {
        void uri$iv$iv;
        void $this$post$iv$iv;
        void uri$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DriveApiGatewayService driveApiGatewayService = this;
        URI uRI = this.videoTeaserUri(videoId);
        MultipartFile file$iv = file;
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder$iv = new MultipartBodyBuilder();
        builder$iv.part("files", (Object)file$iv.getResource());
        WebClient webClient = this_$iv.webClient;
        void var10_9 = uri$iv;
        MultiValueMap multiValueMap = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv$iv = multiValueMap;
        boolean $i$f$post = false;
        List ids = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        if (ids.size() > 1) {
            throw new IllegalStateException("Received " + ids.size() + " ids for " + file.getOriginalFilename());
        }
        return (DriveId.DriveDocument)CollectionsKt.first((List)ids);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeVideoTeaser(@NotNull DriveId.DriveDocument videoId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.videoTeaserUri(videoId);
        boolean $i$f$delete = false;
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ <T> T uploadFile(URI uri, MultipartFile file) {
        void uri$iv;
        void $this$post$iv;
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("files", (Object)file.getResource());
        WebClient webClient = this.webClient;
        URI uRI = uri;
        MultiValueMap multiValueMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv = multiValueMap;
        boolean $i$f$post = false;
        Intrinsics.needClassReification();
        return (T)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI shareUri(String shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/" + shareId + "/withSubscription"), null, null, (int)6, null);
    }

    private URI sharesUri(int offset, int limit) {
        Map map;
        Map $this$sharesUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$sharesUri_u24lambda_u240.put("offset", offset);
        $this$sharesUri_u24lambda_u240.put("limit", limit);
        $this$sharesUri_u24lambda_u240.put("orderBy", "SUBSCRIBED");
        $this$sharesUri_u24lambda_u240.put("orderDirection", "DESC");
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/page"), (Map)params, null, (int)4, null);
    }

    private URI subscribeToShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/subscribe"), null, null, (int)6, null);
    }

    private URI unsubscribeFromShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/unsubscribe"), null, null, (int)6, null);
    }

    private URI folderDetailsUri(String folderId, int offset, int limit) {
        Map map;
        Map $this$folderDetailsUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$folderDetailsUri_u24lambda_u240.put("offset", offset);
        $this$folderDetailsUri_u24lambda_u240.put("limit", limit);
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/folder/" + folderId), (Map)params, null, (int)4, null);
    }

    private URI documentDetailsUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/document/" + documentId), null, null, (int)6, null);
    }

    private URI deleteDocumentUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/file/" + documentId), null, null, (int)6, null);
    }

    private URI downloadAttachmentUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/" + id + "/download"), null, null, (int)6, null);
    }

    private URI videoTeaserUri(DriveId.DriveDocument id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/video/" + id.getId() + "/teaser"), null, null, (int)6, null);
    }

    private URI downloadAttachmentPreviewUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/previewImage/" + id + "/latest"), null, null, (int)6, null);
    }

    private String downloadAttachmentVideoStreamUrl(String id) {
        return this.driveApiUrl + "/previews/embed/" + id + "/latest";
    }

    private URI driveAccessTokenUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/preview/" + id + "/accessToken"), null, null, (int)6, null);
    }

    private URI tempFileUploadUri() {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/tmp/upload"), null, null, (int)6, null);
    }

    private URI folderUploadUri(DriveId.DriveDocument folderId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/" + folderId.getId() + "/upload"), null, null, (int)6, null);
    }

    private URI addFolderUri() {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/document"), null, null, (int)6, null);
    }
}

