/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.google.common.collect.Multimap;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.kafka.model.KafkaFieldMapping;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="ProfileFieldmapping")
@ParametersAreNonnullByDefault
public class DbScimProfileFieldMapping {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private UUID id;
    @Column(nullable=false)
    private UUID tenantId;
    @Column(nullable=false)
    private int version;
    @JdbcTypeCode(value=3001)
    @Column(nullable=false)
    private Multimap<String, String> mapping;
    @Column(nullable=false)
    private Instant createdAt;
    @Column(nullable=false)
    private Long createdBy;

    public DbScimProfileFieldMapping() {
    }

    public DbScimProfileFieldMapping(UUID tenantId, int version, Multimap<String, String> mapping, Instant createdAt, Long createdBy) {
        this.tenantId = tenantId;
        this.version = version;
        this.mapping = mapping;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
    }

    public KafkaFieldMapping toKafkaRecord() {
        return new KafkaFieldMapping(this.getVersion(), this.getTenantId(), this.getMapping(), this.createdAt, ProfileId.fromLongId((Long)this.createdBy));
    }

    public UUID getId() {
        return this.id;
    }

    public TenantId getTenantId() {
        return new TenantId(this.tenantId);
    }

    public int getVersion() {
        return this.version;
    }

    public Multimap<String, String> getMapping() {
        return this.mapping;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Long getCreatedBy() {
        return this.createdBy;
    }
}

