--liquibase formatted sql

--changeset cewers:add_timestamps dbms:postgresql runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION update_mtime()
RETURNS TRIGGER AS $$
BEGIN
   NEW.mtime = clock_timestamp();
   RETURN NEW;
END;
$$ language 'plpgsql';

CREATE OR REPLACE FUNCTION ctime_mtime_columns(tname TEXT)
RETURNS VOID AS $$
BEGIN
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN ctime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN mtime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW EXECUTE PROCEDURE update_mtime();';
END;
$$ language 'plpgsql';

--changeset cewers:add_now_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION now
    RETURN DATE
AS
BEGIN
    RETURN SYSDATE;
END now;

--changeset cewers:add_clock_timestamp_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    RETURN SYSTIMESTAMP;
END clock_timestamp;

--changeset cewers:add_timestamps dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;

--changeset cewers:create_user_login_table
CREATE TABLE user_login (
    id ${uuid} NOT NULL PRIMARY KEY,
    profile_id ${int64} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    id_token ${varchar4000} NOT NULL,
    registration_id ${varchar255} NOT NULL,
    version ${int64} NOT NULL
);
${execute} ctime_mtime_columns('user_login');

--changeset christian.ewers:add_tracking_settings_table
CREATE TABLE tracking_settings(
    PRIMARY KEY (tenant_id),
    tenant_id ${uuid} NOT NULL,
    matomo_url ${varchar1024},
    matomo_site_id ${varchar255},
    matomo_auth_token ${varchar1024},
    version ${int64} NOT NULL
);
${execute} ctime_mtime_columns('tracking_settings');

--changeset christian.ewers:persist_client_registrations
CREATE TABLE client_registration (
    registration_id ${varchar255} PRIMARY KEY,
    tenant_id ${uuid},
    client_id ${varchar255} NOT NULL,
    client_secret ${varchar255} NULL,
    client_name ${varchar255} NOT NULL,
    username_attribute ${varchar255} NOT NULL,
    authorization_grant_type ${varchar64} NOT NULL,
    scope ${varchar255},
    issuer_uri ${varchar1024} NULL,
    authorization_uri ${varchar1024} NOT NULL,
    token_uri ${varchar1024} NOT NULL,
    user_info_uri ${varchar1024},
    redirect_uri ${varchar1024} NOT NULL,
    jwk_set_uri ${varchar1024},
    targets ${varchar1024},
    default_provider ${bool} DEFAULT 'f' NOT NULL,
    end_session_endpoint ${varchar1024},
    version ${int64} NOT NULL
);
${execute} ctime_mtime_columns('client_registration');

--changeset christian.ewers:make_idtoken_nullable dbms:postgresql
ALTER TABLE user_login ALTER COLUMN id_token DROP NOT NULL;

--changeset christian.ewers:make_idtoken_nullable dbms:oracle
ALTER TABLE user_login MODIFY id_token NULL;

--changeset chritian.ewers:add_expires_at_to_userlogin
ALTER TABLE user_login ADD COLUMN expires_at TIMESTAMP;
UPDATE user_login SET expires_at = ctime + interval '90 days' where expires_at IS NULL;
ALTER TABLE user_login ALTER COLUMN expires_at SET NOT NULL;

--changeset christian.ewers:allow_login_without_tenant
ALTER TABLE user_login ALTER COLUMN tenant_id DROP NOT NULL;

--changeset argo.liivanurm:drop_tracking_settings_table
DROP TABLE tracking_settings;
