/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka;

import de.justsoftware.gateway.ids.ProfileId;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ProfileIdDeserializer
implements Deserializer<ProfileId> {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileIdDeserializer.class);

    public ProfileId deserialize(@Nullable String topic, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            String id = new String(data, StandardCharsets.UTF_8);
            return ProfileId.parse((String)id);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Could not parse incoming ProfileId.", (Throwable)e);
            return null;
        }
    }
}

