/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.search.SearchAuthorizationContext;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import javax.annotation.Nonnull;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@SecurityScheme(name="oauth2", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(authorizationCode=@OAuthFlow(authorizationUrl="/toro/oauth/authorize", tokenUrl="/toro/oauth/token", scopes={@OAuthScope(name="api", description="Access to your data in Just Drive")})))
public class SwaggerConfiguration
implements InitializingBean {
    @Nonnull
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group("Webclient API").pathsToMatch(new String[]{"/api/**"}).build();
    }

    @Nonnull
    public GroupedOpenApi internalApi() {
        return GroupedOpenApi.builder().group("Internal").displayName("Internal API").pathsToMatch(new String[]{"/internal"}).build();
    }

    @Bean
    @Nonnull
    public OpenAPI driveApi() {
        return new OpenAPI().info(new Info().title("Just Drive API"));
    }

    public void afterPropertiesSet() throws Exception {
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{AuthorizationContext.class}).addRequestWrapperToIgnore(new Class[]{PersonAuthorizationContext.class}).addRequestWrapperToIgnore(new Class[]{SearchAuthorizationContext.class});
    }
}

