/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.versionupdate;

import de.justsoftware.drive.common.versionupdate.model.DriveVersionBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionId;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessStatus;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessId;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import de.justsoftware.drive.persistence.versionupdate.VersionCreateModel;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@ParametersAreNonnullByDefault
@Mapper
public interface DriveVersionMapper {
    @Options(useGeneratedKeys=true, keyColumn="id", keyProperty="id")
    @Insert(value={"INSERT INTO drive_version( version)", "VALUES (#{_version})"})
    public void insert(VersionCreateModel var1);

    @Select(value={"<script>", "SELECT * ", "FROM ( SELECT max(id) OVER () max_version_id, id, version FROM drive_version) v", "WHERE id = v.max_version_id", "</script>"})
    @ConstructorArgs(value={@Arg(javaType=DriveVersionId.class, column="id", id=true), @Arg(javaType=String.class, column="version")})
    @CheckForNull
    public DriveVersionBO getLastestVersion();

    @Insert(value={"INSERT INTO version_update_process(drive_version_id, id, processor_type, status, processor_version)", "VALUES ( #{_driveVersionId}, #{_processId}, #{_processorType}, #{_status}, #{_processorVersion})"})
    public void insertProcess(DriveVersionUpdateProcessBO var1);

    @Update(value={"UPDATE version_update_process", "SET status = #{status} WHERE id = #{processId}"})
    public void updateProcess(@Param(value="processId") UpdateProcessId var1, @Param(value="status") DriveVersionUpdateProcessStatus var2);

    @Select(value={"<script>", "SELECT * FROM version_update_process ", "WHERE drive_version_id = #{versionId} ", "<if test=\"status != null\"> AND status = #{status}</if>", "ORDER BY id ASC", "</script>"})
    @ConstructorArgs(value={@Arg(javaType=DriveVersionId.class, column="drive_version_id"), @Arg(javaType=UpdateProcessId.class, column="id", id=true), @Arg(javaType=UpdateProcessorType.class, column="processor_type"), @Arg(javaType=DriveVersionUpdateProcessStatus.class, column="status"), @Arg(javaType=int.class, column="processor_version")})
    @Results(id="DriveVersionUpdateProcessBOMap")
    @Nonnull
    public List<DriveVersionUpdateProcessBO> getProcessesForVersion(@Param(value="versionId") DriveVersionId var1, @Nullable @Param(value="status") DriveVersionUpdateProcessStatus var2);

    @Select(value={"<script>", "SELECT * FROM (SELECT max(drive_version_id) over (partition by processor_type) max_version_id, id, drive_version_id, processor_type, processor_version, status FROM version_update_process dvup WHERE status = 'COMPLETE' ) vp ", "WHERE vp.drive_version_id = max_version_id", "</script>"})
    @ResultMap(value={"DriveVersionUpdateProcessBOMap"})
    @MapKey(value="processorType")
    @Nonnull
    public Map<UpdateProcessorType, DriveVersionUpdateProcessBO> getLatestCompletedProcessesVersions();
}

